<?php
header("Content-type: text/html; charset=iso-8859-1");
/*
Dieses Skript darf von jedem verwendet werden.
Die Installation und Verwendung des Programms WeltExplorer v4.7.3 erfolgt auf eigene Gefahr.
Bei Fragen E-Mail an: webmaster@weltvolk.de
Letzte Aenderung: 04.05.2011
*/
//@error_reporting(E_ALL);
if (get_magic_quotes_gpc() == 1) {
  function strip ($x) {
    return is_array($x) ? array_map("strip", $x) : stripslashes($x);
  }
  $_POST = strip($_POST);
  $_REQUEST = strip($_REQUEST);
  $_FILES = strip($_FILES);
}
$programm = "WeltExplorer v4.7.3";
$dateiname = $_SERVER["PHP_SELF"];
$scriptdir = substr($_SERVER["SCRIPT_FILENAME"], 0, -(strlen(substr(strrchr($_SERVER["SCRIPT_FILENAME"], "/"), 1)) +1));
$verzeichnis = array_key_exists("verzeichnis", $_REQUEST) ? path_slash_replace(trim($_REQUEST["verzeichnis"])) : $scriptdir;
$tempdir = slash($verzeichnis, "weltexplorer_" . date("r"));
$ordner = !empty($_POST["ordner"]) ? trim(slash_delete($_POST["ordner"])) : "";
$datei = !empty($_POST["datei"]) ? trim(slash_delete($_POST["datei"])) : "";
$data = !empty($_POST["data"]) ? $_POST["data"] : "";
$xordner = !empty($_POST["xordner"]) ? $_POST["xordner"] : "";
$xdatei = !empty($_POST["xdatei"]) ? $_POST["xdatei"] : "";
$xdata = !empty($_POST["xdata"]) ? $_POST["xdata"] : "";
$auth_neu = !empty($_POST["auth_neu"]) ? $_POST["auth_neu"] : 0;
$case = !empty($_POST["case"]) ? $_POST["case"] : 0;
$chmodnum = !empty($_POST["chmodnum"]) ? num_filter($_POST["chmodnum"]) : "";
$delete = !empty($_POST["delete"]) ? $_POST["delete"] : "";
$gz = !empty($_POST["gz"]) ? $_POST["gz"] : "";
$neu = !empty($_POST["neu"]) ? trim(slash_delete($_POST["neu"])) : "";
$subdir = !empty($_POST["subdir"]) ? $_POST["subdir"] : 0;
$teilnum = !empty($_POST["teilnum"]) ? num_filter($_POST["teilnum"]) : 1;
$text = !empty($_POST["text"]) ? $_POST["text"] : "";
$transquelle = !empty($_POST["transquelle"]) ? path_slash_replace(trim($_POST["transquelle"])) : "";
$transziel = !empty($_POST["transziel"]) ? path_slash_replace(trim($_POST["transziel"])) : "";
$zeichenkette = !empty($_POST["zeichenkette"]) ? $_POST["zeichenkette"] : "";
$zeichenkette2 = !empty($_POST["zeichenkette2"]) ? $_POST["zeichenkette2"] : "";
$ziel = !empty($_POST["ziel"]) ? path_slash_replace(trim($_POST["ziel"])) : "";
$server = !empty($_POST["server"]) ? trim($_POST["server"]) : "";
$benutzer = !empty($_POST["benutzer"]) ? trim($_POST["benutzer"]) : "";
$passwort = !empty($_POST["passwort"]) ? trim($_POST["passwort"]) : "";
$connect = !empty($server) ? @ftp_connect($server) : "";
$ftp_login = !empty($server) ? @ftp_login($connect, $benutzer, $passwort) : "";
$ersetzen_end = array("htm", "html", "php");
$highlight_end = array("css", "htm", "html", "php", "txt");
$suchen_end = array("css", "htm", "html", "ini", "php", "txt");
$limit = 1024 * 6000;
$zeichen = 20480;
if (!isset($_POST["download_gz"]) OR empty($gz)) {
  echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<head>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">
<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">
<style type=\"text/css\">
p, td, a { font-family:arial,sans-serif; font-size:10pt; color:#000000; text-align:left }
body { background-color:#FFFFFF; margin-left:20px; margin-right:20px; margin-top:30px; margin-bottom:20px }
.right { text-align:right }
.center { text-align:center }
.b { font-weight:bold }
.mono { font-family:monospace }
.gruen { color:#008000 }
.rot { color:#BB0000 }
.gelb { color:#FF9900 }
.blau { color:#006699 }
.neutral { font-family:monospace; color:#444444; font-weight:bold }
.neutral td { font-family:monospace; color:#444444; font-weight:bold }
.grau { background-color:#AAAAAA }
.grau2 { background-color:#DDDDDD }
.grau3 { color:#444444 }
.grau4 { color:#999999 }
.td1 { width:1%; text-align:center; padding-left:10px; padding-right:10px }
.td2 { width:96%; padding-left:10px; padding-right:10px }
.td3 { width:1%; padding-left:10px; padding-right:10px }
.td33 { width:2%; padding-left:10px; padding-right:10px }
.w100 { width:100% }
.list td { white-space:nowrap; height:40px; vertical-align:middle }
.list a { color:#003366; background-color:#AAAAAA; text-decoration:none }
.list a:hover { color:#000000 }
.mr10 { margin-right:10px }
.pl { padding-left:10px }
.button { width:150px }
.nobr { white-space:nowrap }
.nobr td { white-space:nowrap }
.size12 { font-size:12pt }
.size14 { font-size:14pt }
.size18 { font-size:18pt }
#ueb { font-size:14pt; font-weight:bold; font-family:monospace; color:#444444; text-align:center }
#nein { margin-left:10px; width:120px; color:#BB0000 }
#ja { width:120px; color:#008000 }
#reset { margin-left:10px; width:120px; color:#FF9900 }
</style>
<title>$programm</title>
</head>
<body>";
}
function login_form () {
  echo "<tr>
      <td>Server:<br>
<input type=\"text\" name=\"server\" size=\"25\"></td>
    </tr>
    <tr>
      <td>Benutzer:<br>
<input type=\"text\" name=\"benutzer\" size=\"25\"></td>
    </tr>
    <tr>
      <td>Passwort:<br>
<input type=\"password\" name=\"passwort\" size=\"25\"></td>
    </tr>";
}
function server_logout () {
  global $connect, $server;
  if (ftp_quit($connect)) {
    echo "<p class=\"b mono gruen\">Verbindung zu " . space_html($server) . " wurde getrennt</p>";
  } else {
    echo "<p class=\"b mono rot\">Verbindung zu " . space_html($server) . " konnte nicht getrennt werden</p>";
  }
}
function highlight_code ($x) {
  $y = @highlight_file($x, true);
  if (!empty($y)) {
    echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"3\">
    <tr>
      <td class=\"size14 b mono grau4\">" . space_html($x) . "</td>
    </tr>
    <tr>
      <td class=\"nobr size12\">$y</td>
    </tr>
  </table>";
  } else {
    echo "<p class=\"b mono rot\">Quelltext von Datei " . space_html($x) . " kann nicht angezeigt werden</p>";
  }
}
function count_data ($x) {
  $y = data_list($x);
  echo "<p class=\"neutral\">Das aktuelle Verzeichnis enth&auml;lt " . count($y[0]) . " Ordner und " . count($y[1]) . " ";
  if (count($y[1]) == 1) {
    echo "Datei</p>";
  } else {
    echo "Dateien</p>";
  }
}
function tree_dump_sys ($x) {
  global $verzeichnis;
  $y = data_list($x);
  if (!empty($y[0])) {
    foreach ($y[0] as $v) {
      if ($verzeichnis == "/" AND $x == $verzeichnis) {
        echo "[ " . space_html($v) . " ]<br>";
      } elseif ($verzeichnis == "/" AND $x != $verzeichnis AND substr_count($x, "/") == 1) {
        echo "&nbsp;&nbsp;&nbsp;[ " . space_html($v) . " ]<br>";
      } else {
        if ($verzeichnis != "/") {
          echo str_repeat("&nbsp;&nbsp;&nbsp;", substr_count($x, "/") -substr_count($verzeichnis, "/")) . "[ " . space_html($v) . " ]<br>";
        } else {
          echo str_repeat("&nbsp;&nbsp;&nbsp;", substr_count($x, "/") -substr_count($verzeichnis, "/") +1) . "[ " . space_html($v) . " ]<br>";
        }
      }
      tree_dump_sys(slash($x, $v));
    }
  }
  if (!empty($y[1])) {
    foreach ($y[1] as $v) {
      if ($verzeichnis == "/" AND $x == $verzeichnis) {
        echo space_html($v) . "<br>";
      } elseif ($verzeichnis == "/" AND $x != $verzeichnis AND substr_count($x, "/") == 1) {
        echo "&nbsp;&nbsp;&nbsp;" . space_html($v) . "<br>";
      } else {
        if ($verzeichnis != "/") {
          echo str_repeat("&nbsp;&nbsp;&nbsp;", substr_count($x, "/") -substr_count($verzeichnis, "/")) . space_html($v) . "<br>";
        } else {
          echo str_repeat("&nbsp;&nbsp;&nbsp;", substr_count($x, "/") -substr_count($verzeichnis, "/") +1) . space_html($v) . "<br>";
        }
      }
    }
  }
}
function dir_dump_sys ($x) {
  $y = data_list($x);
  if (!empty($y[0])) {
    foreach ($y[0] as $v) {
      echo space_html(slash($x, $v)) . "<br>";
      dir_dump_sys(slash($x, $v));
    }
  }
  if (!empty($y[1])) {
    foreach ($y[1] as $v) {
      echo space_html(slash($x, $v)) . "<br>";
    }
  }
}
function post_dump () {
  if (!empty($_POST)) {
    foreach ($_POST as $key => $value) {
      if (is_array($value)) {
        foreach ($value as $v) {
          echo "<input type=\"hidden\" name=\"" . $key . "[]\" value=\"" . htmlentities($v) . "\">";
        }
      } else {
        echo "<input type=\"hidden\" name=\"$key\" value=\"" . htmlentities($value) . "\">";
      }
    }
  }
}
function header_download ($x) {
  header("Content-Type: application/x-gzip");
  header("Content-Disposition: attachment; filename=\"" . substr(strrchr($x, "/"), 1) . "\"");
  header("Content-Length: " . filesize($x));
  readfile($x);
}
function slash ($x, $z) {
  if ($x == "/" OR substr($x, -1) == "/") {
    return $x . $z;
  } else {
    return $x . "/" . $z;
  }
}
function slash1 ($x) {
  if ($x == "/" OR substr($x, -1) == "/") {
    return $x;
  } else {
    return $x . "/";
  }
}
function path_slash_replace ($x) {
  if (strpos($x, "//") !== false) {
    return path_slash_replace(str_replace("//", "/", $x));
  } elseif ($x != "/" AND substr($x, -1) == "/") {
    return substr($x, 0, -1);
  } else {
    return $x;
  }
}
function slash_delete ($x) {
  return str_replace("/", "", $x);
}
function space_html ($x) {
  return str_replace(" ", "&nbsp;", htmlentities($x));
}
function data_split ($x, $y) {
  $z = array();
  $fp = @fopen($x, "rb");
  $i = 0;
  while ($a = @fread($fp, $y)) {
    $z[$i] = $a;
    $i++;
  }
  @fclose($fp);
  return $z;
}
if (!function_exists("array_replace")) {
  function array_replace ($x, $y) {
    $z = func_get_args();
    for ($i = 0; $i < func_num_args(); ++$i) {
      if (is_array($z[$i])) {
        foreach ($z[$i] as $k => $v) {
          $x[$k] = $v;
        }
      } else {
        return null;
      }
    }
    return $x;
  }
}
function array_surf ($x, $y) {
  if ($y <= 1 OR $y > count($x)) {
    $z[0] = $x[0];
  } else {
    $i = $y - 1;
    $z[$i] = $x[$i];
  }
  return $z;
}
function num_filter ($x) {
  $y = array();
  if (function_exists("str_split")) {
    $z = str_split($x);
  } else {
    $z = preg_split("//", $x, -1, PREG_SPLIT_NO_EMPTY);
  }
  if (!empty($z)) {
    foreach ($z as $v) {
      if (is_numeric($v)) {
        $y[] = $v;
      }
    }
  }
  return implode("", $y);
}
function show_button_sys ($x, $y) {
  if (!empty($x) AND !empty($y)) {
    foreach ($x as $v) {
      foreach ($y as $value) {
        if (substr(strrchr(strtolower($value), "."), 1) == $v) {
          return true;
        }
      }
    }
  }
}
function show_button_auth ($x) {
  if (@in_array(".htaccess", $x) AND @in_array(".htpasswd", $x)) {
    return false;
  } elseif (@in_array(".htaccess", $x) AND @in_array(".htusers", $x)) {
    return false;
  }
}
function show_button_edit ($x) {
  if (!empty($x)) {
    foreach ($x as $v) {
      if (is_writeable($v)) {
        return true;
      }
    }
  }
}
function not_disabled ($x) {
  if (strpos(get_cfg_var("disable_functions"), $x) === false) {
    return true;
  }
}
function html_implode ($x) {
  $y = array();
  if (!empty($x)) {
    foreach ($x as $v) {
      $y[] = space_html($v);
    }
  }
  return implode("<br>", $y);
}
function strpos_umlaut ($x) {
  $y = array("", "", "", "", "", "", "");
  foreach ($y as $v) {
    if (strpos($x, $v) !== false) {
      return true;
    }
  }
}
function data_list ($x) {
  @chdir($x);
  if ($y = @opendir($x)) {
    $a = array();
    $b = array();
    while (($z = readdir($y)) !== false) {
      if ($z != "." AND $z != "..") {
        if (@filetype(slash($x, $z)) == "dir") {
          $a[] = $z;
        } elseif (@filetype(slash($x, $z)) == "file") {
          $b[] = $z;
        }
      }
    }
    if (!empty($a)) {
      sort($a);
    }
    if (!empty($b)) {
      sort($b);
    }
    return (!empty($a) OR !empty($b)) ? array($a, $b) : false;
  } else {
    return false;
  }
}
function tree_delete_sys ($x) {
  $y = data_list($x);
  if (!empty($y[0])) {
    foreach ($y[0] as $v) {
      @rmdir(slash($x, $v));
      tree_delete_sys(slash($x, $v));
    }
  }
  if (!empty($y[1])) {
    foreach ($y[1] as $v) {
      @unlink(slash($x, $v));
    }
  }
  if (@rmdir($x)) {
    return true;
  } else {
    return false;
  }
}
function dir_copy_sys ($x) {
  global $verzeichnis;
  $y = data_list($x);
  $z = substr(strrchr($x, "/"), 1);
  if (slash1($verzeichnis) == substr($x, 0, -strlen($z))) {
    if (!@mkdir(slash($verzeichnis, "Kopie_" . $z))) {
      return false;
    }
  }
  if (!empty($y[0])) {
    foreach ($y[0] as $v) {
      @mkdir(slash(slash1($verzeichnis) . "Kopie_" . substr($x, strlen(slash1($verzeichnis))), $v));
      dir_copy_sys(slash($x, $v));
    }
  }
  if (!empty($y[1])) {
    foreach ($y[1] as $v) {
      @copy(slash($x, $v), slash(slash1($verzeichnis) . "Kopie_" . substr($x, strlen(slash1($verzeichnis))), $v));
    }
  }
}
function ftp_download ($x, $y) {
  global $server, $benutzer, $passwort;
  $url = "ftp://" . $benutzer . ":" . $passwort . "@" . $server . ":21" . $x;
  if (!$fp = @fopen($y, "wb")) {
    return false;
  }
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 0);
  curl_setopt($ch, CURLOPT_UPLOAD, 0);
  curl_setopt($ch, CURLOPT_FILE, $fp);
  if (curl_exec($ch) !== false) {
    curl_close($ch);
    fclose($fp);
    return true;
  } else {
    curl_close($ch);
    fclose($fp);
    if (file_exists($y)) {
      unlink($y);
    }
    return false;
  }
}
function ftp_upload ($x, $y) {
  global $server, $benutzer, $passwort;
  $url = "ftp://" . $benutzer . ":" . $passwort . "@" . $server . ":21" . $y;
  if (!$fp = @fopen($x, "rb")) {
    return false;
  }
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_UPLOAD, 1);
  curl_setopt($ch, CURLOPT_INFILE, $fp);
  @curl_setopt($ch, CURLOPT_INFILESIZE, filesize($x));
  if (curl_exec($ch) !== false) {
    curl_close($ch);
    fclose($fp);
    return true;
  } else {
    curl_close($ch);
    fclose($fp);
    return false;
  }
}
function dir_download ($x) {
  global $tempdir, $quellverzeichnis;
  $y = remote_rawlist($x);
  if (@mkdir(slash($tempdir, substr(strrchr($x, "/"), 1)))) {
    $a = array("1");
  }
  if (!empty($y[0])) {
    foreach ($y[0] as $v) {
      @mkdir(slash(slash1($tempdir) . substr($x, strlen($quellverzeichnis)), $v));
      dir_download(slash($x, $v));
    }
  }
  if (!empty($y[1])) {
    foreach ($y[1] as $v) {
      ftp_download(slash($x, $v), slash(slash1($tempdir) . substr($x, strlen($quellverzeichnis)), $v));
    }
  }
  return !empty($a) ? true : false;
}
function root_download ($x) {
  global $tempdir;
  $y = remote_rawlist($x);
  if (!empty($y[0])) {
    foreach ($y[0] as $v) {
      if (@mkdir($tempdir . slash($x, $v))) {
        root_download(slash($x, $v));
      } else {
        return false;
      }
    }
  }
  if (!empty($y[1])) {
    foreach ($y[1] as $v) {
      ftp_download(slash($x, $v), $tempdir . slash($x, $v));
    }
  }
}
function dir_upload ($x) {
  global $connect, $transziel, $verzeichnis;
  $y = data_list($x);
  $z = substr(strrchr($x, "/"), 1);
  if (slash1($verzeichnis) == substr($x, 0, -strlen($z))) {
    if (!@ftp_mkdir($connect, slash($transziel, $z))) {
      return false;
    }
  }
  if (!empty($y[0])) {
    foreach ($y[0] as $v) {
      @ftp_mkdir($connect, slash(slash1($transziel) . substr($x, strlen(slash1($verzeichnis))), $v));
      dir_upload(slash($x, $v));
    }
  }
  if (!empty($y[1])) {
    foreach ($y[1] as $v) {
      ftp_upload(slash($x, $v), slash(slash1($transziel) . substr($x, strlen(slash1($verzeichnis))), $v));
    }
  }
}
function remote_rawlist ($x) {
  global $connect;
  $y = ftp_rawlist($connect, $x);
  if (!empty($y)) {
    foreach ($y as $v) {
      $b = array();
      $a = preg_split("/[\s]+/", $v, 9);
      if ($a[0] != "total" AND $a[8] != "." AND $a[8] != "..") {
        $b["chmod"] = $a[0];
        $b["nr"] = $a[1];
        $b["eigner"] = $a[2];
        $b["gruppe"] = $a[3];
        $b["groesse"] = $a[4];
        $b["monat"] = $a[5];
        $b["tag"] = $a[6];
        $b["zeit"] = $a[7];
        $b["name"] = $a[8];
        $z[$b["name"]] = $b;
      }
    }
  }
  if (!empty($z)) {
    $c = array();
    $d = array();
    foreach ($z as $v) {
      if ($v["chmod"][0] == "d") {
        $c[] = $v["name"];
      } elseif ($v["chmod"][0] == "-") {
        $d[] = $v["name"];
      }
    }
  }
  return (!empty($c) OR !empty($d)) ? array($c, $d) : false;
}
function umlaut_replace ($x) {
  $a = array("", "", "", "", "", "", "");
  $b = array("&Auml;", "&auml;", "&Ouml;", "&ouml;", "&Uuml;", "&uuml;", "&szlig;");
  if ($x == $_SERVER["SCRIPT_FILENAME"] OR @filesize($x) == 0) {
    return false;
  } elseif (!$fp = @fopen($x, "rb")) {
    return false;
  } else {
    $y = fread($fp, filesize($x));
    fclose($fp);
  }
  return ($fp = @fopen($x, "wb") AND fwrite($fp, str_replace($a, $b, $y)) !== false AND fclose($fp)) ? true : false;
}
function string_search ($x) {
  global $case, $suchen_end, $zeichenkette;
  if (filesize($x) == 0) {
    return false;
  } elseif (!$fp = @fopen($x, "rb")) {
    return false;
  } else {
    if (!@in_array(substr(strrchr(strtolower($x), "."), 1), $suchen_end)) {
      fclose($fp);
      return false;
    } else {
      $y = fread($fp, filesize($x));
      fclose($fp);
      if ($case == 1) {
        $z = strpos($y, $zeichenkette);
      } else {
        if (function_exists("stripos")) {
          $z = stripos($y, $zeichenkette);
        } else {
          $z = strpos(strtolower($y), strtolower($zeichenkette));
        }
      }
    }
  }
  return $z !== false ? true : false;
}
function string_search_recursive ($x, $y = 1) {
  global $subdir;
  $z = data_list($x);
  $a = array();
  if (!empty($z[0]) AND $subdir == $y) {
    foreach ($z[0] as $v) {
      $a[] = string_search_recursive(slash($x, $v));
    }
  }
  if (!empty($z[1])) {
    foreach ($z[1] as $v) {
      if (string_search(slash($x, $v))) {
        if (is_writeable(slash($x, $v))) {
          $a[] = "<input type=\"checkbox\" class=\"mr10\" name=\"xdata[]\" value=\"" . htmlentities(slash($x, $v)) . "\">" . space_html(slash($x, $v));
        } else {
          $a[] = "<input type=\"checkbox\" class=\"mr10\" name=\"xdata[]\" value=\"" . htmlentities(slash($x, $v)) . "\"><span class=\"rot\">" . space_html(slash($x, $v)) . "</span>";
        }
      }
    }
  }
  return !empty($a) ? array_to_string($a) : false;
}
function array_to_string ($x, $y = 1) {
  $z = array();
  if (!empty($x)) {
    foreach ($x as $v) {
      if (!empty($v)) {
        if (is_array($v)) {
          $z[] = array_to_string($v);
        } else {
          $z[] = $v;
        }
      } else {
        unset($v);
      }
    }
  }
  return !empty($z) ? implode("<br>", $z) : false;
}
function string_replace ($x) {
  global $case, $zeichenkette, $zeichenkette2;
  if (@filesize($x) == 0) {
    return false;
  } elseif (!$fp = @fopen($x, "rb")) {
    return false;
  } else {
    $y = fread($fp, filesize($x));
    fclose($fp);
  }
  if ($case == 1) {
    $z = str_replace($zeichenkette, $zeichenkette2, $y);
  } else {
    if (function_exists("str_ireplace")) {
      $z = str_ireplace($zeichenkette, $zeichenkette2, $y);
    } else {
      $z = preg_replace("/$zeichenkette/i", $zeichenkette2, $y);
    }
  }
  return ($fp = @fopen($x, "wb") AND fwrite($fp, $z) !== false AND fclose($fp)) ? true : false;
}
if (!isset($_POST["download_gz"]) OR empty($gz)) {
  echo "<p class=\"size18 b mono grau3 center\">" . space_html($programm) . "</p>";
}
if (isset($_POST["mkdir"])) {
  if (!empty($ordner)) {
    $inhalt = data_list($verzeichnis);
    if (!@in_array($ordner, $inhalt[0]) AND !@in_array($ordner, $inhalt[1])) {
      if (strpos($ordner, "?") === false) {
        $nordner = slash($verzeichnis, $ordner);
        if (@mkdir($nordner)) {
          echo "<p class=\"b mono gruen\">Verzeichnis " . space_html($nordner) . " wurde erstellt</p>";
        } else {
          echo "<p class=\"b mono rot\">Verzeichnis konnte nicht erstellt werden</p>";
        }
      } else {
        echo "<p class=\"b mono rot\">Ordnername enth&auml;lt Fragezeichen &#63; als unzul&auml;ssiges Zeichen</p>";
      }
    } else {
      echo "<p class=\"b mono rot\">Name schon vorhanden</p>";
    }
  } else {
    echo "<p class=\"b mono rot\">Kein Ordnername angegeben</p>";
  }
} elseif (isset($_POST["rmdir_delete"])) {
  if (isset($_POST["ja"])) {
    if (!empty($xordner)) {
      $gruen = array();
      $rot = array();
      foreach ($xordner as $v) {
        if (@rmdir($v) OR tree_delete_sys($v)) {
          $gruen[] = space_html($v);
        } else {
          $rot[] = space_html($v);
        }
      }
      if (!empty($gruen)) {
        echo "<p class=\"b mono gruen\">";
        if (count($gruen) == 1) {
          echo "Verzeichnis $gruen[0] wurde gel&ouml;scht";
        } else {
          echo "Folgende Verzeichnisse wurden gel&ouml;scht:<br>";
          echo implode("<br>", $gruen);
        }
      }
      if (!empty($rot)) {
        echo "<p class=\"b mono rot\">";
        if (count($rot) == 1) {
          echo "Verzeichnis $rot[0] konnte nicht gel&ouml;scht werden";
        } else {
          echo "Folgende Verzeichnisse konnten nicht gel&ouml;scht werden:<br>";
          echo implode("<br>", $rot);
        }
      }
      echo "</p>";
    }
    if (!empty($xdatei)) {
      $gruen = array();
      $rot = array();
      foreach ($xdatei as $v) {
        if (@unlink($v)) {
          $gruen[] = space_html($v);
        } else {
          $rot[] = space_html($v);
        }
      }
      if (!empty($gruen)) {
        echo "<p class=\"b mono gruen\">";
        if (count($gruen) == 1) {
          echo "Datei $gruen[0] wurde gel&ouml;scht";
        } else {
          echo "Folgende Dateien wurden gel&ouml;scht:<br>";
          echo implode("<br>", $gruen);
        }
      }
      if (!empty($rot)) {
        echo "<p class=\"b mono rot\">";
        if (count($rot) == 1) {
          echo "Datei $rot[0] konnte nicht gel&ouml;scht werden";
        } else {
          echo "Folgende Dateien konnten nicht gel&ouml;scht werden:<br>";
          echo implode("<br>", $rot);
        }
      }
      echo "</p>";
    }
  } else {
    if (!empty($xordner) OR !empty($xdatei)) {
      echo "<form action=\"$dateiname\" method=\"post\">";
      post_dump();
      echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Sollen folgende Daten wirklich gel&ouml;scht werden?</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono gelb\">";
      if (!empty($xordner)) {
        foreach ($xordner as $v) {
          echo space_html($v) . "<br>";
          dir_dump_sys($v);
        }
      }
      if (!empty($xdatei)) {
        echo html_implode($xdatei);
      }
      echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"L&ouml;schen\"></td>
    </tr>
  </table>
</form>";
    } else {
      echo "<p class=\"b mono rot\">Keine Daten angegeben</p>";
    }
  }
} elseif (isset($_POST["rename"])) {
  if (!empty($xordner) OR !empty($xdatei)) {
    $inhalt = data_list($verzeichnis);
    $vneu = slash($verzeichnis, $neu);
    $xdaten = array();
    if (!empty($xordner)) {
      foreach ($xordner as $v) {
        $xdaten[] = $v;
      }
    }
    if (!empty($xdatei)) {
      foreach ($xdatei as $v) {
        $xdaten[] = $v;
      }
    }
    if (count($xdaten) > 1) {
      if (isset($_POST["ja2"])) {
        if (!empty($xdata)) {
          if (isset($_POST["ja3"])) {
            if (!@in_array($neu, $inhalt[0]) AND !@in_array($neu, $inhalt[1])) {
              if (strpos($neu, "?") === false) {
                if (@rename($xdata, $vneu)) {
                  echo "<p class=\"b mono gruen\">" . space_html($xdata) . " wurde in " . space_html($vneu) . " umbenannt</p>";
                } else {
                  echo "<p class=\"b mono rot\">" . space_html($xdata) . " konnte nicht umbenannt werden</p>";
                }
              } else {
                echo "<p class=\"b mono rot\">Name enth&auml;lt Fragezeichen &#63; als unzul&auml;ssiges Zeichen</p>";
              }
            } else {
              echo "<p class=\"b mono rot\">Name " . space_html($vneu) . " schon vorhanden</p>";
            }
          } else {
            echo "<form action=\"$dateiname\" method=\"post\">";
            post_dump();
            echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">" . space_html($xdata) . " umbenennen in:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"nobr neutral\">";
            echo space_html(slash1($verzeichnis)) . "<input type=\"text\" class=\"mr10\" name=\"neu\" size=\"25\" value=\"" . htmlentities(substr(strrchr($xdata, "/"), 1)) . "\"><input type=\"submit\" name=\"ja3\" id=\"ja\" value=\"Umbenennen\"></td>
    </tr>
  </table>
</form>";
          }
        } else {
          echo "<p class=\"b mono rot\">Keine Daten angegeben</p>";
        }
      } else {
        echo "<form action=\"$dateiname\" method=\"post\">";
        post_dump();
        echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Welche(s) Verzeichnis/Datei soll umbenannt werden?</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>";
        if (!empty($xordner)) {
          foreach ($xordner as $v) {
            echo "<tr>
      <td class=\"nobr neutral pl\">
<input type=\"radio\" class=\"mr10\" name=\"xdata\" value=\"" . htmlentities($v) . "\">" . space_html($v) . "</td>
    </tr>";
          }
        }
        if (!empty($xdatei)) {
          foreach ($xdatei as $v) {
            echo "<tr>
      <td class=\"nobr neutral pl\">
<input type=\"radio\" class=\"mr10\" name=\"xdata\" value=\"" . htmlentities($v) . "\">" . space_html($v) . "</td>
    </tr>";
          }
        }
        echo "<tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"ja2\" id=\"ja\" value=\"Umbenennen\"></td>
    </tr>
  </table>
</form>";
      }
    } else {
      if (isset($_POST["ja"])) {
        if (!@in_array($neu, $inhalt[0]) AND !@in_array($neu, $inhalt[1])) {
          if (strpos($neu, "?") === false) {
            if (!empty($xordner)) {
              if (@rename($xordner[0], $vneu)) {
                echo "<p class=\"b mono gruen\">Verzeichnis " . space_html($xordner[0]) . " wurde in " . space_html($vneu) . " umbenannt</p>";
              } else {
                echo "<p class=\"b mono rot\">Verzeichnis " . space_html($xordner[0]) . " konnte nicht umbenannt werden</p>";
              }
            } elseif (!empty($xdatei)) {
              if (@rename($xdatei[0], $vneu)) {
                echo "<p class=\"b mono gruen\">Datei " . space_html($xdatei[0]) . " wurde in " . space_html($vneu) . " umbenannt</p>";
              } else {
                echo "<p class=\"b mono rot\">Datei " . space_html($xdatei[0]) . " konnte nicht umbenannt werden</p>";
              }
            }
          } else {
            echo "<p class=\"b mono rot\">Name enth&auml;lt Fragezeichen &#63; als unzul&auml;ssiges Zeichen</p>";
          }
        } else {
          echo "<p class=\"b mono rot\">Name " . space_html($vneu) . " schon vorhanden</p>";
        }
      } else {
        echo "<form action=\"$dateiname\" method=\"post\">";
        post_dump();
        echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
        if (!empty($xordner)) {
          echo "<tr>
      <td class=\"b mono gelb\">Verzeichnis " . space_html($xordner[0]) . " umbenennen in:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"nobr neutral\">";
          echo space_html(slash1($verzeichnis)) . "<input type=\"text\" class=\"mr10\" name=\"neu\" size=\"25\" value=\"" . htmlentities(substr(strrchr($xordner[0], "/"), 1)) . "\"><input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Umbenennen\">";
        } elseif (!empty($xdatei)) {
          echo "<tr>
      <td class=\"b mono gelb\">Datei " . space_html($xdatei[0]) . " umbenennen in:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"nobr neutral\">";
          echo space_html(slash1($verzeichnis)) . "<input type=\"text\" class=\"mr10\" name=\"neu\" size=\"25\" value=\"" . htmlentities(substr(strrchr($xdatei[0], "/"), 1)) . "\"><input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Umbenennen\">";
        }
        echo "</td>
    </tr>
  </table>
</form>";
      }
    }
  } else {
    echo "<p class=\"b mono rot\">Keine Daten angegeben</p>";
  }
} elseif (isset($_POST["move"])) {
  if (isset($_POST["ja"])) {
    if (!empty($ziel)) {
      $inhalt = data_list($ziel);
      if (!empty($xordner)) {
        $a = array();
        foreach ($xordner as $v) {
          $a[$v] = slash($ziel, substr(strrchr($v, "/"), 1));
        }
        if (!empty($a)) {
          $gruen = array();
          $rot = array();
          $rotvorhanden = array();
          $gleich = array();
          $vorhanden = array();
          foreach ($a as $k => $v) {
            $name = substr(strrchr($k, "/"), 1);
            if (!@in_array($name, $inhalt[0])) {
              if (@rename($k, $v)) {
                $gruen[] = space_html($k);
              } else {
                if (!@in_array($name, $inhalt[1])) {
                  $rot[] = space_html($k);
                } else {
                  $rotvorhanden[] = space_html($v);
                }
              }
            } else {
              if ($ziel == $verzeichnis) {
                $gleich[] = space_html($v);
              } else {
                $vorhanden[] = space_html($v);
              }
            }
          }
          if (!empty($gruen)) {
            echo "<p class=\"b mono gruen\">";
            if (count($gruen) == 1) {
              echo "Verzeichnis $gruen[0] wurde nach " . space_html($ziel) . " verschoben";
            } else {
              echo "Folgende Verzeichnisse wurden nach " . space_html($ziel) . " verschoben:<br>";
              echo implode("<br>", $gruen);
            }
          }
          if (!empty($rot)) {
            echo "<p class=\"b mono rot\">";
            if (count($rot) == 1) {
              echo "Verzeichnis $rot[0] konnte nicht verschoben werden";
            } else {
              echo "Folgende Verzeichnisse konnten nicht verschoben werden:<br>";
              echo implode("<br>", $rot);
            }
          }
          if (!empty($rotvorhanden)) {
            echo "<p class=\"b mono rot\">";
            if (count($rotvorhanden) == 1) {
              echo "$rotvorhanden[0] in Zielverzeichnis " . space_html($ziel) . " als Datei vorhanden";
            } else {
              echo "Als Dateien sind in Zielverzeichnis " . space_html($ziel) . " vorhanden:<br>";
              echo implode("<br>", $rotvorhanden);
            }
          }
          if (!empty($gleich)) {
            echo "<p class=\"b mono rot\">Zielverzeichnis " . space_html($ziel) . " ist aktuelles Verzeichnis - ";
            if (count($gleich) == 1) {
              echo "Verzeichnis $gleich[0] schon vorhanden";
            } else {
              echo "folgende Verzeichnisse sind schon vorhanden:<br>";
              echo implode("<br>", $gleich);
            }
          }
          if (!empty($vorhanden)) {
            echo "<p class=\"b mono rot\">";
            if (count($vorhanden) == 1) {
              echo "Verzeichnis $vorhanden[0] in Zielverzeichnis " . space_html($ziel) . " schon vorhanden";
            } else {
              echo "Folgende Verzeichnisse sind in Zielverzeichnis " . space_html($ziel) . " schon vorhanden:<br>";
              echo implode("<br>", $vorhanden);
            }
          }
          echo "</p>";
        }
      }
      if (!empty($xdatei)) {
        $a = array();
        foreach ($xdatei as $v) {
          $a[$v] = slash($ziel, substr(strrchr($v, "/"), 1));
        }
        if (!empty($a)) {
          $gruen = array();
          $rot = array();
          $rotvorhanden = array();
          $gleich = array();
          $vorhanden = array();
          $verschieben = array();
          foreach ($a as $k => $v) {
            $name = substr(strrchr($k, "/"), 1);
            if (!@in_array($name, $inhalt[1])) {
              if (@rename($k, $v)) {
                $gruen[] = space_html($k);
              } else {
                if (!@in_array($name, $inhalt[0])) {
                  $rot[] = space_html($k);
                } else {
                  $rotvorhanden[] = space_html($v);
                }
              }
            } else {
              if ($ziel == $verzeichnis) {
                $gleich[] = space_html($v);
              } else {
                $vorhanden[] = space_html($v);
                $verschieben[] = $k;
              }
            }
          }
          if (!empty($gruen)) {
            echo "<p class=\"b mono gruen\">";
            if (count($gruen) == 1) {
              echo "Datei $gruen[0] wurde nach " . space_html($ziel) . " verschoben";
            } else {
              echo "Folgende Dateien wurden nach " . space_html($ziel) . " verschoben:<br>";
              echo implode("<br>", $gruen);
            }
          }
          if (!empty($rot)) {
            echo "<p class=\"b mono rot\">";
            if (count($rot) == 1) {
              echo "Datei $rot[0] konnte nicht verschoben werden";
            } else {
              echo "Folgende Dateien konnten nicht verschoben werden:<br>";
              echo implode("<br>", $rot);
            }
          }
          if (!empty($rotvorhanden)) {
            echo "<p class=\"b mono rot\">";
            if (count($rotvorhanden) == 1) {
              echo "$rotvorhanden[0] in Zielverzeichnis " . space_html($ziel) . " als Verzeichnis vorhanden";
            } else {
              echo "Als Verzeichnisse sind in Zielverzeichnis " . space_html($ziel) . " vorhanden:<br>";
              echo implode("<br>", $rotvorhanden);
            }
          }
          if (!empty($gleich)) {
            echo "<p class=\"b mono rot\">Zielverzeichnis " . space_html($ziel) . " ist aktuelles Verzeichnis - ";
            if (count($gleich) == 1) {
              echo "Datei $gleich[0] schon vorhanden";
            } else {
              echo "folgende Dateien sind schon vorhanden:<br>";
              echo implode("<br>", $gleich);
            }
          }
          echo "</p>";
          if (!empty($vorhanden)) {
            echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">";
            if (!empty($verschieben)) {
              foreach ($verschieben as $v) {
                echo "<input type=\"hidden\" name=\"data[]\" value=\"" . htmlentities($v) . "\">";
              }
            }
            echo "<input type=\"hidden\" name=\"ziel\" value=\"" . htmlentities($ziel) . "\">
  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">";
            if (count($vorhanden) == 1) {
              echo "Datei $vorhanden[0] in Zielverzeichnis " . space_html($ziel) . " schon vorhanden - soll vorhandene Datei &uuml;berschrieben werden?";
            } else {
              echo "Folgende Dateien sind in Zielverzeichnis " . space_html($ziel) . " schon vorhanden - sollen vorhandene Dateien &uuml;berschrieben werden?<br><br>";
              echo implode("<br>", $vorhanden);
            }
            echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"move_overwrite\" id=\"ja\" value=\"Verschieben\"></td>
    </tr>
  </table>
</form>";
          }
        }
      }
    } else {
      echo "<p class=\"b mono rot\">Kein Zielverzeichnis angegeben</p>";
    }
  } else {
    if (!empty($xordner) OR !empty($xdatei)) {
      echo "<form action=\"$dateiname\" method=\"post\">";
      post_dump();
      echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Folgende Daten verschieben nach:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>
<input type=\"text\" name=\"ziel\" size=\"40\" value=\"" . htmlentities(slash1($verzeichnis)) . "\"></td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono gelb\">";
      if (!empty($xordner)) {
        foreach ($xordner as $v) {
          echo space_html($v) . "<br>";
          dir_dump_sys($v);
        }
      }
      if (!empty($xdatei)) {
        echo html_implode($xdatei);
      }
      echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Verschieben\"></td>
    </tr>
  </table>
</form>";
    } else {
      echo "<p class=\"b mono rot\">Keine Daten angegeben</p>";
    }
  }
} elseif (isset($_POST["move_overwrite"])) {
  if (!empty($data)) {
    $a = array();
    foreach ($data as $v) {
      $a[$v] = slash($ziel, substr(strrchr($v, "/"), 1));
    }
    if (!empty($a)) {
      $gruen = array();
      $rot = array();
      foreach ($a as $k => $v) {
        if (@rename($k, $v)) {
          $gruen[] = space_html($k);
        } else {
          $rot[] = space_html($k);
        }
      }
      if (!empty($gruen)) {
        echo "<p class=\"b mono gruen\">";
        if (count($gruen) == 1) {
          echo "Datei $gruen[0] wurde nach " . space_html($ziel) . " verschoben";
        } else {
          echo "Folgende Dateien wurden nach " . space_html($ziel) . " verschoben:<br>";
          echo implode("<br>", $gruen);
        }
      }
      if (!empty($rot)) {
        echo "<p class=\"b mono rot\">";
        if (count($rot) == 1) {
          echo "Datei $rot[0] konnte nicht verschoben werden";
        } else {
          echo "Folgende Dateien konnten nicht verschoben werden:<br>";
          echo implode("<br>", $rot);
        }
      }
      echo "</p>";
    }
  }
} elseif (isset($_POST["chmod"])) {
  if (isset($_POST["ja"])) {
    if (!empty($chmodnum)) {
      if (strlen($chmodnum) <= 4) {
        if (!empty($xordner)) {
          $gruen = array();
          $rot = array();
          foreach ($xordner as $v) {
            if (@chmod($v, octdec($chmodnum))) {
              $gruen[] = space_html($v);
            } else {
              $rot[] = space_html($v);
            }
          }
          if (!empty($gruen)) {
            echo "<p class=\"b mono gruen\">";
            if (count($gruen) == 1) {
              echo "Die Rechte von Verzeichnis $gruen[0] wurden in $chmodnum ge&auml;ndert";
            } else {
              echo "Die Rechte folgender Verzeichnisse wurden in $chmodnum ge&auml;ndert:<br>";
              echo implode("<br>", $gruen);
            }
          }
          if (!empty($rot)) {
            echo "<p class=\"b mono rot\">";
            if (count($rot) == 1) {
              echo "Die Rechte von Verzeichnis $rot[0] konnten nicht ge&auml;ndert werden";
            } else {
              echo "Die Rechte folgender Verzeichnisse konnten nicht ge&auml;ndert werden:<br>";
              echo implode("<br>", $rot);
            }
          }
          echo "</p>";
        }
        if (!empty($xdatei)) {
          $gruen = array();
          $rot = array();
          foreach ($xdatei as $v) {
            if (@chmod($v, octdec($chmodnum))) {
              $gruen[] = space_html($v);
            } else {
              $rot[] = space_html($v);
            }
          }
          if (!empty($gruen)) {
            echo "<p class=\"b mono gruen\">";
            if (count($gruen) == 1) {
              echo "Die Rechte von Datei $gruen[0] wurden in $chmodnum ge&auml;ndert";
            } else {
              echo "Die Rechte folgender Dateien wurden in $chmodnum ge&auml;ndert:<br>";
              echo implode("<br>", $gruen);
            }
          }
          if (!empty($rot)) {
            echo "<p class=\"b mono rot\">";
            if (count($rot) == 1) {
              echo "Die Rechte von Datei $rot[0] konnten nicht ge&auml;ndert werden";
            } else {
              echo "Die Rechte folgender Dateien konnten nicht ge&auml;ndert werden:<br>";
              echo implode("<br>", $rot);
            }
          }
          echo "</p>";
        }
      } else {
        echo "<p class=\"b mono rot\">Eingabe enth&auml;lt mehr als vier Ziffern</p>";
      }
    } else {
      echo "<p class=\"b mono rot\">Keine Rechte angegeben</p>";
    }
  } else {
    if (!empty($xordner) OR !empty($xdatei)) {
      echo "<form action=\"$dateiname\" method=\"post\">";
      post_dump();
      echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
      $xchmod = array();
      if (!empty($xordner)) {
        foreach ($xordner as $v) {
          $xchmod[] = space_html($v);
        }
      }
      if (!empty($xdatei)) {
        foreach ($xdatei as $v) {
          $xchmod[] = space_html($v);
        }
      }
      echo "<tr>
      <td class=\"b mono gelb\">Die Rechte folgender Daten &auml;ndern in:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>
<input type=\"text\" name=\"chmodnum\" size=\"5\" value=\"0644\"></td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono gelb\">";
      if (!empty($xchmod)) {
        echo implode("<br>", $xchmod);
      }
      echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Chmodden\"></td>
    </tr>
  </table>
</form>";
    } else {
      echo "<p class=\"b mono rot\">Keine Daten angegeben</p>";
    }
  }
} elseif (isset($_POST["upload"])) {
  $inhalt = data_list($verzeichnis);
  $name = $_FILES["file"]["name"];
  $zieldatei = slash($verzeichnis, $name);
  if (!@in_array($name, $inhalt[0])) {
    $tmp_name = $_FILES["file"]["tmp_name"];
    $type = $_FILES["file"]["type"];
    $text = @file_get_contents($tmp_name);
    if (@in_array($name, $inhalt[1])) {
      $neu_name = "neu_" . $name;
      $tempziel = slash($scriptdir, $neu_name);
      if (@in_array(substr(strrchr(strtolower($name), "."), 1), $highlight_end)) {
        $handle = @move_uploaded_file($tmp_name, $tempziel) AND ($fp = @fopen($tempziel, "wb") AND fwrite($fp, str_replace("\r\n", "\n", $text)) !== false AND fclose($fp));
        $size = @filesize($tempziel);
      } else {
        $handle = @move_uploaded_file($tmp_name, $tempziel);
        $size = $_FILES["file"]["size"];
      }
      if ($handle) {
        echo "<p class=\"b mono gruen\">Datei wurde als tempor&auml;re Datei hochgeladen</p>
<p class=\"neutral\">Dateiname: " . space_html($neu_name) . "<br>
Dateityp: $type<br>
Dateigr&ouml;&szlig;e: $size Byte</p>
<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"name\" value=\"" . htmlentities($name) . "\">
<input type=\"hidden\" name=\"zieldatei\" value=\"" . htmlentities($zieldatei) . "\">
<input type=\"hidden\" name=\"tempziel\" value=\"" . htmlentities($tempziel) . "\">
  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Soll vorhandene Datei " . space_html($name) . " ersetzt werden?</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"upload_ja\" id=\"ja\" value=\"Ja\"><input type=\"submit\" name=\"upload_nein\" id=\"nein\" value=\"Nein\"></td>
    </tr>
  </table>
</form>";
      } else {
        echo "<p class=\"b mono rot\">Datei " . space_html($tempziel) . " konnte nicht hochgeladen werden";
        if (!is_writeable($scriptdir)) {
          echo " - Skriptverzeichnis " . space_html($scriptdir) . " nicht beschreibbar";
        }
        echo "</p>";
      }
    } else {
      if (@in_array(substr(strrchr(strtolower($name), "."), 1), $highlight_end)) {
        $handle = move_uploaded_file($tmp_name, $zieldatei) AND ($fp = @fopen($zieldatei, "wb") AND fwrite($fp, str_replace("\r\n", "\n", $text)) !== false AND fclose($fp));
        $size = filesize($zieldatei);
      } else {
        $handle = move_uploaded_file($tmp_name, $zieldatei);
        $size = $_FILES["file"]["size"];
      }
      if ($handle) {
        echo "<p class=\"b mono gruen\">Datei wurde hochgeladen</p>
<p class=\"neutral\">Dateiname: " . space_html($name) . "<br>
Dateityp: $type<br>
Dateigr&ouml;&szlig;e: $size Byte</p>";
      } else {
        echo "<p class=\"b mono rot\">Es wurde keine Datei hochgeladen</p>";
      }
    }
  } else {
    echo "<p class=\"b mono rot\">" . space_html($zieldatei) . " als Verzeichnis vorhanden</p>";
  }
} elseif (isset($_POST["upload_nein"])) {
  echo "<p class=\"b mono gruen\">Datei " . space_html($_POST["name"]) . " wurde nicht ersetzt";
  if (!@unlink($_POST["tempziel"])) {
    echo "<br>
<span class=\"rot\">Tempor&auml;re Datei " . space_html($_POST["tempziel"]) . " konnte nicht gel&ouml;scht werden</span>";
  }
  echo "</p>";
} elseif (isset($_POST["upload_ja"])) {
  if (@rename($_POST["tempziel"], $_POST["zieldatei"])) {
    echo "<p class=\"b mono gruen\">Datei " . space_html($_POST["name"]) . " wurde ersetzt";
  } else {
    echo "<p class=\"b mono rot\">Datei " . space_html($_POST["zieldatei"]) . " konnte nicht ersetzt werden";
    if (!@unlink($_POST["tempziel"])) {
      echo "<br>
Tempor&auml;re Datei " . space_html($_POST["tempziel"]) . " konnte nicht gel&ouml;scht werden";
    }
  }
  echo "</p>";
} elseif (isset($_POST["copy"])) {
  if (!empty($xordner) OR !empty($xdatei)) {
    if (!empty($xordner)) {
      if (is_writeable($verzeichnis)) {
        $inhalt = data_list($verzeichnis);
        $gruen = array();
        $rot = array();
        $vorhanden = array();
        foreach ($xordner as $v) {
          $name = substr(strrchr($v, "/"), 1);
          $kopiename = "Kopie_" . $name;
          $kopie = substr($v, 0, -strlen($name)) . $kopiename;
          if (dir_copy_sys($v) !== false) {
            $gruen[] = space_html($v);
          } else {
            if (@in_array($kopiename, $inhalt[0]) OR @in_array($kopiename, $inhalt[1])) {
              $vorhanden[] = space_html($kopie);
            } else {
              $rot[] = space_html($v);
            }
          }
        }
        if (!empty($gruen)) {
          echo "<p class=\"b mono gruen\">";
          if (count($gruen) == 1) {
            echo "Verzeichnis $gruen[0] wurde kopiert";
          } else {
            echo "Folgende Verzeichnisse wurden kopiert:<br>";
            echo implode("<br>", $gruen);
          }
        }
        if (!empty($rot)) {
          echo "<p class=\"b mono rot\">";
          if (count($rot) == 1) {
            echo "Verzeichnis $rot[0] konnte nicht kopiert werden";
          } else {
            echo "Folgende Verzeichnisse konnten nicht kopiert werden:<br>";
            echo implode("<br>", $rot);
          }
        }
        if (!empty($vorhanden)) {
          echo "<p class=\"b mono rot\">";
          if (count($vorhanden) == 1) {
            echo "Kopie $vorhanden[0] schon vorhanden";
          } else {
            echo "Folgende Kopien sind schon vorhanden:<br>";
            echo implode("<br>", $vorhanden);
          }
        }
        echo "</p>";
      } else {
        echo "<p class=\"b mono rot\">Verzeichnisse k&ouml;nnen nicht kopiert werden - aktuelles Verzeichnis " . space_html($verzeichnis) . " nicht beschreibbar</p>";
      }
    }
    if (!empty($xdatei)) {
      echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">";
      foreach ($xdatei as $v) {
        echo "<input type=\"hidden\" name=\"data[]\" value=\"" . htmlentities($v) . "\">";
      }
      echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Folgende Datei(en) kopieren nach:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>
<input type=\"text\" name=\"ziel\" size=\"40\" value=\"" . htmlentities(slash1($verzeichnis)) . "\"></td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono gelb\">";
      echo html_implode($xdatei) . "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"copy_file\" id=\"ja\" value=\"Kopieren\"></td>
    </tr>
  </table>
</form>";
    }
  } else {
    echo "<p class=\"b mono rot\">Keine Daten angegeben</p>";
  }
} elseif (isset($_POST["copy_file"])) {
  if (!empty($data)) {
    if (!empty($ziel)) {
      $inhalt = data_list($ziel);
      $a = array();
      foreach ($data as $v) {
        $a[$v] = slash($ziel, substr(strrchr($v, "/"), 1));
      }
      if (!empty($a)) {
        $gruen = array();
        $rot = array();
        $vorhanden = array();
        $rotverzeichnis = array();
        $rotvorhanden = array();
        $zielvorhanden = array();
        $kopieren = array();
        foreach ($a as $k => $v) {
          $name = substr(strrchr($v, "/"), 1);
          $kopiename = "Kopie_" . $name;
          $kopie = substr($v, 0, -strlen($name)) . $kopiename;
          if ($ziel == $verzeichnis) {
            if (@copy($k, $kopie)) {
              if (@in_array($kopiename, $inhalt[1])) {
                $vorhanden[] = space_html($kopie);
              } else {
                $gruen[] = space_html($k);
              }
            } else {
              if (!@in_array($kopiename, $inhalt[0])) {
                if (is_writeable($verzeichnis)) {
                  $rot[] = space_html($k);
                } else {
                  $rotverzeichnis[] = space_html($k);
                }
              } else {
                $rotvorhanden[] = space_html($kopie);
              }
            }
          } else {
            if (!@in_array($name, $inhalt[1])) {
              if (@copy($k, $v)) {
                $gruen[] = space_html($k);
              } else {
                if (!@in_array($name, $inhalt[0])) {
                  $rot[] = space_html($k);
                } else {
                  $rotvorhanden[] = space_html($v);
                }
              }
            } else {
              $zielvorhanden[] = space_html($v);
              $kopieren[] = $k;
            }
          }
        }
        if (!empty($gruen)) {
          echo "<p class=\"b mono gruen\">";
          if (count($gruen) == 1) {
            echo "Datei $gruen[0] wurde";
            if ($ziel != $verzeichnis) {
              echo " nach " . space_html($ziel);
            }
            echo " kopiert";
          } else {
            echo "Folgende Dateien wurden";
            if ($ziel != $verzeichnis) {
              echo " nach " . space_html($ziel);
            }
            echo " kopiert:<br>";
            echo implode("<br>", $gruen);
          }
        }
        if (!empty($vorhanden)) {
          echo "<p class=\"b mono gruen\">";
          if (count($vorhanden) == 1) {
            echo "Kopie $vorhanden[0] wurde &uuml;berschrieben";
          } else {
            echo "Folgende Kopien wurden &uuml;berschrieben:<br>";
            echo implode("<br>", $vorhanden);
          }
        }
        if (!empty($rot)) {
          echo "<p class=\"b mono rot\">";
          if (count($rot) == 1) {
            echo "Datei $rot[0] konnte nicht kopiert werden";
          } else {
            echo "Folgende Dateien konnten nicht kopiert werden:<br>";
            echo implode("<br>", $rot);
          }
        }
        if (!empty($rotverzeichnis)) {
          echo "<p class=\"b mono rot\">";
          if (count($rotverzeichnis) == 1) {
            echo "Datei $rotverzeichnis[0] konnte nicht kopiert werden - aktuelles Verzeichnis " . space_html($verzeichnis) . " nicht beschreibbar";
          } else {
            echo "Folgende Dateien konnten nicht kopiert werden - aktuelles Verzeichnis " . space_html($verzeichnis) . " nicht beschreibbar:<br>";
            echo implode("<br>", $rotverzeichnis);
          }
        }
        if (!empty($rotvorhanden)) {
          echo "<p class=\"b mono rot\">";
          if (count($rotvorhanden) == 1) {
            echo "$rotvorhanden[0]";
            if ($ziel != $verzeichnis) {
              echo " in Zielverzeichnis " . space_html($ziel);
            }
            echo " als Verzeichnis vorhanden";
          } else {
            echo "Als Verzeichnisse sind";
            if ($ziel != $verzeichnis) {
              echo " in Zielverzeichnis " . space_html($ziel);
            }
            echo " vorhanden:<br>";
            echo implode("<br>", $rotvorhanden);
          }
        }
        echo "</p>";
        if (!empty($zielvorhanden)) {
          echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">";
          if (!empty($kopieren)) {
            foreach ($kopieren as $v) {
              echo "<input type=\"hidden\" name=\"data[]\" value=\"" . htmlentities($v) . "\">";
            }
          }
          echo "<input type=\"hidden\" name=\"ziel\" value=\"" . htmlentities($ziel) . "\">
  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">";
          if (count($zielvorhanden) == 1) {
            echo "Datei $zielvorhanden[0] in Zielverzeichnis " . space_html($ziel) . " schon vorhanden - soll vorhandene Datei &uuml;berschrieben werden?";
          } else {
            echo "Folgende Dateien sind in Zielverzeichnis " . space_html($ziel) . " schon vorhanden - sollen vorhandene Dateien &uuml;berschrieben werden?<br><br>";
            echo implode("<br>", $zielvorhanden);
          }
          echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"copy_overwrite\" id=\"ja\" value=\"Kopieren\"></td>
    </tr>
  </table>
</form>";
        }
      }
    } else {
      echo "<p class=\"b mono rot\">Kein Zielverzeichnis angegeben</p>";
    }
  }
} elseif (isset($_POST["copy_overwrite"])) {
  if (!empty($data)) {
    $a = array();
    foreach ($data as $v) {
      $a[$v] = slash($ziel, substr(strrchr($v, "/"), 1));
    }
    if (!empty($a)) {
      $gruen = array();
      $rot = array();
      foreach ($a as $k => $v) {
        if (@copy($k, $v)) {
          $gruen[] = space_html($k);
        } else {
          $rot[] = space_html($k);
        }
      }
      if (!empty($gruen)) {
        echo "<p class=\"b mono gruen\">";
        if (count($gruen) == 1) {
          echo "Datei $gruen[0] wurde nach " . space_html($ziel) . " kopiert";
        } else {
          echo "Folgende Dateien wurden nach " . space_html($ziel) . " kopiert:<br>";
          echo implode("<br>", $gruen);
        }
      }
      if (!empty($rot)) {
        echo "<p class=\"b mono rot\">";
        if (count($rot) == 1) {
          echo "Datei $rot[0] konnte nicht kopiert werden";
        } else {
          echo "Folgende Dateien konnten nicht kopiert werden:<br>";
          echo implode("<br>", $rot);
        }
      }
      echo "</p>";
    }
  }
} elseif (isset($_POST["download"])) {
  if (!empty($xdatei)) {
    $download = array();
    $rot = array();
    $rotlimit = array();
    $rotnull = array();
    foreach ($xdatei as $v) {
      if (@filesize($v) != 0) {
        if (filesize($v) <= $limit) {
          $name = substr(strrchr($v, "/"), 1);
          if ($name[0] == ".") {
            $gzname = "weltexplorer_" . $name . ".gz";
          } else {
            $gzname = $name . ".gz";
          }
          $gzip = slash($scriptdir, $gzname);
          if ($fp = @fopen($gzip, "wb") AND @fwrite($fp, gzencode(file_get_contents($v))) AND @fclose($fp)) {
            $download[] = $gzip;
          } else {
            $rot[] = space_html($v);
          }
        } else {
          $rotlimit[] = space_html($v);
        }
      } else {
        $rotnull[] = space_html($v);
      }
    }
    if (!empty($download)) {
      echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">";
      foreach ($download as $v) {
        echo "<input type=\"hidden\" name=\"delete[]\" value=\"" . htmlentities($v) . "\">";
      }
      echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gruen\">";
      if (count($download) == 1) {
        echo "Datei wurde gzip-komprimiert und kann heruntergeladen werden:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono blau\">
<input type=\"hidden\" name=\"gz[]\" value=\"" . htmlentities($download[0]) . "\">" . space_html($download[0]) . "</td>
    </tr>";
      } else {
        echo "Folgende Dateien wurden gzip-komprimiert und k&ouml;nnen heruntergeladen werden:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>";
        foreach ($download as $v) {
          echo "<tr>
      <td class=\"nobr b mono blau pl\">
<input type=\"radio\" class=\"mr10\" name=\"gz[]\" value=\"" . htmlentities($v) . "\">" . space_html($v) . "</td>
    </tr>";
        }
      }
      echo "<tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"download_gz\" id=\"ja\" value=\"Downloaden\"><input type=\"submit\" name=\"unlink_temp\" id=\"nein\" value=\"Abbrechen\"></td>
    </tr>
  </table>
</form>";
    }
    if (!empty($rot)) {
      echo "<p class=\"b mono rot\">";
      if (count($rot) == 1) {
        echo "Datei $rot[0] konnte f&uuml;r einen Download nicht gzip-komprimiert werden";
      } else {
        echo "Folgende Dateien konnten f&uuml;r einen Download nicht gzip-komprimiert werden:<br>";
        echo implode("<br>", $rot);
      }
    }
    if (!empty($rotlimit)) {
      echo "<p class=\"b mono rot\">";
      if (count($rotlimit) == 1) {
        echo "Datei $rotlimit[0] konnte f&uuml;r einen Download nicht gzip-komprimiert werden, da das Gr&ouml;&szlig;enlimit in H&ouml;he von $limit Byte &uuml;berschritten wurde";
      } else {
        echo "Folgende Dateien konnten f&uuml;r einen Download nicht gzip-komprimiert werden, da das Gr&ouml;&szlig;enlimit in H&ouml;he von $limit Byte &uuml;berschritten wurde:<br>";
        echo implode("<br>", $rotlimit);
      }
    }
    if (!empty($rotnull)) {
      echo "<p class=\"b mono rot\">";
      if (count($rotnull) == 1) {
        echo "Datei $rotnull[0] konnte f&uuml;r einen Download nicht gzip-komprimiert werden - Dateigr&ouml;&szlig;e 0 Byte";
      } else {
        echo "Folgende Dateien konnten f&uuml;r einen Download nicht gzip-komprimiert werden - Dateigr&ouml;&szlig;e 0 Byte:<br>";
        echo implode("<br>", $rotnull);
      }
    }
    echo "</p>";
  } else {
    echo "<p class=\"b mono rot\">Keine Datei angegeben</p>";
  }
} elseif (isset($_POST["download_gz"])) {
  if (!empty($gz)) {
    foreach ($gz as $v) {
      header_download($v);
    }
  } else {
    echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono rot\">Keine Datei angegeben</td>
    </tr>
      <td>&nbsp;</td>
    </tr>";
    if (!empty($delete)) {
      foreach ($delete as $v) {
        if (@unlink($v)) {
          echo "<tr>
      <td class=\"b mono gruen\">" . space_html($v) . " wurde gel&ouml;scht</td>
    </tr>";
        } else {
          echo "<tr>
      <td class=\"b mono rot\">" . space_html($v) . " konnte nicht gel&ouml;scht werden</td>
    </tr>";
        }
      }
    }
    echo "</table>";
  }
} elseif (isset($_POST["unlink_temp"])) {
  echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
  if (!empty($delete)) {
    foreach ($delete as $v) {
      if (@unlink($v)) {
        echo "<tr>
      <td class=\"b mono gruen\">" . space_html($v) . " wurde gel&ouml;scht</td>
    </tr>";
      } else {
        echo "<tr>
      <td class=\"b mono rot\">" . space_html($v) . " konnte nicht gel&ouml;scht werden</td>
    </tr>";
      }
    }
  }
  echo "</table>";
} elseif (isset($_POST["edit"])) {
  if (!empty($xdatei)) {
    if (count($xdatei) > 1) {
      if (isset($_POST["ja"])) {
        if (!empty($xdata)) {
          if (is_readable($xdata) AND is_writeable($xdata)) {
            $data_split = data_split($xdata, $zeichen);
            $count_split = count($data_split);
            $name = substr(strrchr($xdata, "/"), 1);
            echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"data\" value=\"" . htmlentities($xdata) . "\">
  <table border=\"0\" width=\"100%\">
    <tr>
      <td width=\"49%\">&nbsp;</td>
      <td width=\"2%\">
  <table class=\"nobr grau2\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">
    <tr>
      <td id=\"ueb\">" . space_html($xdata) . "</td>
    </tr>
    <tr>
      <td class=\"center\">
<textarea name=\"text[0]\" cols=\"80\" rows=\"25\">";
            echo @htmlentities($data_split[0]);
            echo "</textarea></td>
    </tr>";
            if ($count_split > 1) {
              echo "<tr>
      <td class=\"neutral center\">
<input type=\"submit\" class=\"button\" name=\"teil\" value=\"Teilnummer\"> <input type=\"text\" name=\"teilnum\" value=\"$teilnum\" size=\"5\"> von $count_split</td>
    </tr>";
            }
            if ($name == ".htpasswd" OR $name == ".htusers") {
              echo "<tr>
      <td class=\"neutral center\">
Benutzer: <input type=\"text\" name=\"auth_user\" size=\"15\">
und Passwort: <input type=\"password\" name=\"auth_pass\" size=\"15\">
<input type=\"submit\" class=\"button\" name=\"auth_data\" value=\"hinzuf&uuml;gen\"></td>
    </tr>";
            }
            echo "<tr>
      <td class=\"center\">
<input type=\"submit\" name=\"edit_ja\" id=\"ja\" value=\"Speichern\"><input type=\"reset\" id=\"reset\" value=\"Zur&uuml;cksetzen\"></td>
    </tr>
  </table></td>
      <td width=\"49%\">&nbsp;</td>
    </tr>
  </table>
</form>";
          } else {
            echo "<p class=\"b mono rot\">Datei " . space_html($xdata) . " kann nicht bearbeitet werden</p>";
          }
        } else {
          echo "<p class=\"b mono rot\">Keine Datei angegeben</p>";
        }
      } else {
        echo "<form action=\"$dateiname\" method=\"post\">";
        post_dump();
        echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Welche Datei soll bearbeitet werden?</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>";
        foreach ($xdatei as $v) {
          echo "<tr>
      <td class=\"nobr neutral pl\">
<input type=\"radio\" class=\"mr10\" name=\"xdata\" value=\"" . htmlentities($v) . "\">" . space_html($v) . "</td>
    </tr>";
        }
        echo "<tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Bearbeiten\"></td>
    </tr>
  </table>
</form>";
      }
    } else {
      if (is_readable($xdatei[0]) AND is_writeable($xdatei[0])) {
        $data_split = data_split($xdatei[0], $zeichen);
        $count_split = count($data_split);
        $name = substr(strrchr($xdatei[0], "/"), 1);
        echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"data\" value=\"" . htmlentities($xdatei[0]) . "\">
  <table border=\"0\" width=\"100%\">
    <tr>
      <td width=\"49%\">&nbsp;</td>
      <td width=\"2%\">
  <table class=\"nobr grau2\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">
    <tr>
      <td id=\"ueb\">" . space_html($xdatei[0]) . "</td>
    </tr>
    <tr>
      <td class=\"center\">
<textarea name=\"text[0]\" cols=\"80\" rows=\"25\">";
        echo @htmlentities($data_split[0]);
        echo "</textarea></td>
    </tr>";
        if ($count_split > 1) {
          echo "<tr>
      <td class=\"neutral center\">
<input type=\"submit\" class=\"button\" name=\"teil\" value=\"Teilnummer\"> <input type=\"text\" name=\"teilnum\" value=\"$teilnum\" size=\"5\"> von $count_split</td>
    </tr>";
        }
        if ($name == ".htpasswd" OR $name == ".htusers") {
          echo "<tr>
      <td class=\"neutral center\">
Benutzer: <input type=\"text\" name=\"auth_user\" size=\"15\">
und Passwort: <input type=\"password\" name=\"auth_pass\" size=\"15\">
<input type=\"submit\" class=\"button\" name=\"auth_data\" value=\"hinzuf&uuml;gen\"></td>
    </tr>";
        }
        echo "<tr>
      <td class=\"center\">
<input type=\"submit\" name=\"edit_ja\" id=\"ja\" value=\"Speichern\"><input type=\"reset\" id=\"reset\" value=\"Zur&uuml;cksetzen\"></td>
    </tr>
  </table></td>
      <td width=\"49%\">&nbsp;</td>
    </tr>
  </table>
</form>";
      } else {
        echo "<p class=\"b mono rot\">Datei " . space_html($xdatei[0]) . " kann nicht bearbeitet werden</p>";
      }
    }
  } else {
    echo "<p class=\"b mono rot\">Keine Datei angegeben</p>";
  }
} elseif (isset($_POST["create"])) {
  if (!empty($datei)) {
    $inhalt = data_list($verzeichnis);
    if (!@in_array($datei, $inhalt[0]) AND !@in_array($datei, $inhalt[1])) {
      if (strpos($datei, "?") === false) {
        $ndatei = slash($verzeichnis, $datei);
        if (@touch($ndatei) AND is_readable($ndatei) AND is_writeable($ndatei)) {
          echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"data\" value=\"" . htmlentities($ndatei) . "\">
<input type=\"hidden\" name=\"auth_neu\" value=\"1\">
  <table border=\"0\" width=\"100%\">
    <tr>
      <td width=\"49%\">&nbsp;</td>
      <td width=\"2%\">
  <table class=\"nobr grau2\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">
    <tr>
      <td id=\"ueb\">" . space_html($ndatei) . "</td>
    </tr>
    <tr>
      <td class=\"center\">
<textarea name=\"text[0]\" cols=\"80\" rows=\"25\">";
          if (!empty($_POST["name"])) {
            echo "AuthType Basic\nAuthName &quot;Gesch&uuml;tztes Verzeichnis&quot;\nAuthUserFile &quot;" . htmlentities(slash($verzeichnis, $_POST["name"])) . "&quot;\nRequire valid-user";
          }
          echo "</textarea></td>
    </tr>";
          if ($datei == ".htpasswd" OR $datei == ".htusers") {
            echo "<tr>
      <td class=\"neutral center\">
Benutzer: <input type=\"text\" name=\"auth_user\" size=\"15\">
und Passwort: <input type=\"password\" name=\"auth_pass\" size=\"15\">
<input type=\"submit\" class=\"button\" name=\"auth_data\" value=\"hinzuf&uuml;gen\"></td>
    </tr>";
          }
          echo "<tr>
      <td class=\"center\">
<input type=\"submit\" name=\"edit_ja\" id=\"ja\" value=\"Speichern\"><input type=\"reset\" id=\"reset\" value=\"Zur&uuml;cksetzen\"><input type=\"submit\" name=\"create_nein\" id=\"nein\" value=\"Abbrechen\"></td>
    </tr>
  </table></td>
      <td width=\"49%\">&nbsp;</td>
    </tr>
  </table>
</form>";
        } else {
          echo "<p class=\"b mono rot\">Datei " . space_html($ndatei) . " kann nicht erstellt werden</p>";
        }
      } else {
        echo "<p class=\"b mono rot\">Dateiname enth&auml;lt Fragezeichen &#63; als unzul&auml;ssiges Zeichen</p>";
      }
    } else {
      echo "<p class=\"b mono rot\">Name schon vorhanden</p>";
    }
  } else {
    echo "<p class=\"b mono rot\">Kein Dateiname angegeben</p>";
  }
} elseif (isset($_POST["auth_data"])) {
  if (is_readable($data) AND is_writeable($data)) {
    echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"data\" value=\"" . htmlentities($data) . "\">
<input type=\"hidden\" name=\"auth_neu\" value=\"$auth_neu\">
  <table border=\"0\" width=\"100%\">
    <tr>
      <td width=\"49%\">&nbsp;</td>
      <td width=\"2%\">
  <table class=\"nobr grau2\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">
    <tr>
      <td id=\"ueb\">" . space_html($data) . "</td>
    </tr>
    <tr>
      <td class=\"center\">
<textarea name=\"text[0]\" cols=\"80\" rows=\"25\">";
    echo @htmlentities($text[0]);
    if (!empty($_POST["auth_user"]) AND !empty($_POST["auth_pass"])) {
      echo "\n" . trim($_POST["auth_user"]) . ":" . crypt(trim($_POST["auth_pass"]));
    }
    echo "</textarea></td>
    </tr>";
    if (empty($_POST["auth_user"]) OR empty($_POST["auth_pass"])) {
      echo "<tr>
      <td class=\"b mono rot center\">";
      if (empty($_POST["auth_user"]) AND empty($_POST["auth_pass"])) {
        echo "Weder Benutzername noch Passwort";
      } elseif (empty($_POST["auth_user"])) {
        echo "Kein Benutzername";
      } elseif (empty($_POST["auth_pass"])) {
        echo "Kein Passwort";
      }
      echo " angegeben</td>
    </tr>";
    }
    echo "<tr>
      <td class=\"neutral center\">
Benutzer: <input type=\"text\" name=\"auth_user\" size=\"15\">
und Passwort: <input type=\"password\" name=\"auth_pass\" size=\"15\">
<input type=\"submit\" class=\"button\" name=\"auth_data\" value=\"hinzuf&uuml;gen\"></td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"edit_ja\" id=\"ja\" value=\"Speichern\"><input type=\"reset\" id=\"reset\" value=\"Zur&uuml;cksetzen\">";
    if ($auth_neu == 1) {
      echo "<input type=\"submit\" name=\"create_nein\" id=\"nein\" value=\"Abbrechen\">";
    }
    echo "</td>
    </tr>
  </table></td>
      <td width=\"49%\">&nbsp;</td>
    </tr>
  </table>
</form>";
  }
} elseif (isset($_POST["auth"])) {
  $inhalt = data_list($verzeichnis);
  echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">";
  if (@in_array(".htpasswd", $inhalt[1]) OR @in_array(".htusers", $inhalt[1])) {
    if (@in_array(".htpasswd", $inhalt[1])) {
      $name = ".htpasswd";
    } elseif (@in_array(".htusers", $inhalt[1])) {
      $name = ".htusers";
    }
    echo "F&uuml;r den Verzeichnisschutz muss noch die .htaccess-Datei erstellt werden:";
  } else {
    echo "Zum Erstellen der Passwortdatei Dateinamen ausw&auml;hlen:";
  }
  echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td";
  if (@in_array(".htpasswd", $inhalt[1]) OR @in_array(".htusers", $inhalt[1])) {
    echo " class=\"center\">
<input type=\"hidden\" name=\"name\" value=\"$name\">
<input type=\"hidden\" name=\"datei\" value=\".htaccess\">";
  } else {
    echo ">
<select name=\"datei\" class=\"mr10\">
  <option>.htpasswd</option>
  <option>.htusers</option>
</select>";
  }
  echo "<input type=\"submit\" name=\"create\" id=\"ja\" value=\"Erstellen\"></td>
    </tr>
  </table>
</form>";
} elseif (isset($_POST["teil"])) {
  $data_split = data_split($data, $zeichen);
  $name = substr(strrchr($data, "/"), 1);
  foreach (array_surf($data_split, $teilnum) as $k => $v) {
    echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"data\" value=\"" . htmlentities($data) . "\">
  <table border=\"0\" width=\"100%\">
    <tr>
      <td width=\"49%\">&nbsp;</td>
      <td width=\"2%\">
  <table class=\"nobr grau2\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">
    <tr>
      <td id=\"ueb\">" . space_html($data) . "</td>
    </tr>
    <tr>
      <td class=\"center\">
<textarea name=\"text[$k]\" cols=\"80\" rows=\"25\">";
    echo @htmlentities($v);
    echo "</textarea></td>
    </tr>
    <tr>
      <td class=\"neutral center\">
<input type=\"submit\" class=\"button\" name=\"teil\" value=\"Teilnummer\"> <input type=\"text\" name=\"teilnum\" value=\"" . $a = $k + 1 . "\" size=\"5\"> von " . count($data_split) . "</td>
    </tr>";
    if ($name == ".htpasswd" OR $name == ".htusers") {
      echo "<tr>
      <td class=\"neutral center\">
Benutzer: <input type=\"text\" name=\"auth_user\" size=\"15\">
und Passwort: <input type=\"password\" name=\"auth_pass\" size=\"15\">
<input type=\"submit\" class=\"button\" name=\"auth_data\" value=\"hinzuf&uuml;gen\"></td>
    </tr>";
    }
    echo "<tr>
      <td class=\"center\">
<input type=\"submit\" name=\"edit_ja\" id=\"ja\" value=\"Speichern\"><input type=\"reset\" id=\"reset\" value=\"Zur&uuml;cksetzen\"></td>
    </tr>
  </table></td>
      <td width=\"49%\">&nbsp;</td>
    </tr>
  </table>
</form>";
  }
} elseif (isset($_POST["edit_ja"])) {
  $inhalt = data_list($verzeichnis);
  $name = substr(strrchr($data, "/"), 1);
  $data_split = data_split($data, $zeichen);
  if ($fp = @fopen($data, "wb") AND fwrite($fp, str_replace("\r\n", "\n", @implode(array_replace($data_split, $text)))) !== false AND fclose($fp)) {
    echo "<p class=\"b mono gruen\">";
    if ($name == ".htaccess") {
      echo "Verzeichnisschutzdatei ";
    } elseif ($name == ".htpasswd" OR $name == ".htusers") {
      echo "Passwortdatei ";
    } else {
      echo "Datei ";
    }
    echo space_html($data) . " wurde gespeichert</p>";
    if ($name == ".htpasswd" OR $name == ".htusers") {
      if (!@in_array(".htaccess", $inhalt[1])) {
        echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"name\" value=\"$name\">
<input type=\"hidden\" name=\"datei\" value=\".htaccess\">
  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">F&uuml;r den Verzeichnisschutz muss noch die .htaccess-Datei erstellt werden:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"create\" id=\"ja\" value=\"Erstellen\"></td>
    </tr>
  </table>
</form>";
      }
    }
  } else {
    echo "<p class=\"b mono rot\">Datei " . space_html($data) . " konnte nicht gespeichert werden</p>";
  }
} elseif (isset($_POST["create_nein"])) {
  if (file_exists($data)) {
    unlink($data);
  }
} elseif (isset($_POST["ftp_download"])) {
  if (isset($_POST["ja"])) {
    if (!empty($transquelle)) {
      if (!$ftp_login AND !empty($server)) {
        echo "<p class=\"b mono rot\">Anmeldung bei " . space_html($server) . " fehlgeschlagen</p>";
      } elseif (!$ftp_login) {
        echo "<p class=\"b mono rot\">Anmeldung fehlgeschlagen</p>";
      } else {
        if (!ftp_pasv($connect, true)) {
          echo "<p class=\"b mono rot\">Passives FTP konnte nicht eingeschaltet werden - Verbindung zu " . space_html($server) . " ";
          if (ftp_quit($connect)) {
            echo "wurde getrennt</p>";
          } else {
            echo "konnte nicht getrennt werden</p>";
          }
        } else {
          echo "<p class=\"b mono gruen\">Verbindung zu " . space_html($server) . " wurde hergestellt</p>";
          if (!file_exists($tempdir)) {
            mkdir($tempdir);
          }
          if ($transquelle == "/") {
            if (root_download("/") !== false AND rename($tempdir, slash($verzeichnis, $server . "_" . date("r")))) {
              echo "<p class=\"b mono gruen\">Rootverzeichnis auf " . space_html($server) . " wurde heruntergeladen</p>";
            } else {
              echo "<p class=\"b mono rot\">Rootverzeichnis auf " . space_html($server) . " konnte nicht oder nicht vollst&auml;ndig heruntergeladen werden</p>";
            }
          } else {
            $quellname = substr(strrchr($transquelle, "/"), 1);
            $quellverzeichnis = substr($transquelle, 0, -strlen($quellname) -1);
            $quellinhalt = remote_rawlist($quellverzeichnis);
            $tempdata = slash($tempdir, $quellname);
            $zielverzeichnis = slash($verzeichnis, $quellname);
            if (!@in_array($quellname, $quellinhalt[0]) AND !@in_array($quellname, $quellinhalt[1])) {
              echo "<p class=\"b mono rot\">" . space_html($transquelle) . " auf " . space_html($server) . " im angegebenen Quellverzeichnis " . space_html($quellverzeichnis) . " nicht vorhanden</p>";
            } elseif (@in_array($quellname, $quellinhalt[0])) {
              $inhalt = data_list($verzeichnis);
              if (!@in_array($quellname, $inhalt[0])) {
                if (dir_download($transquelle) AND @rename($tempdata, $zielverzeichnis)) {
                  echo "<p class=\"b mono gruen\">Verzeichnis " . space_html($transquelle) . " auf " . space_html($server) . " wurde von Quellverzeichnis " . space_html($quellverzeichnis) . " heruntergeladen</p>";
                } else {
                  echo "<p class=\"b mono rot\">Verzeichnis " . space_html($transquelle) . " konnte nicht heruntergeladen werden</p>";
                }
              } else {
                echo "<p class=\"b mono rot\">Verzeichnis " . space_html($zielverzeichnis) . " schon vorhanden</p>";
              }
            } elseif (@in_array($quellname, $quellinhalt[1])) {
              if (ftp_download($transquelle, $tempdata) AND @rename($tempdata, $zielverzeichnis)) {
                echo "<p class=\"b mono gruen\">Datei " . space_html($transquelle) . " auf " . space_html($server) . " wurde von Quellverzeichnis " . space_html($quellverzeichnis) . " heruntergeladen</p>";
              } else {
                echo "<p class=\"b mono rot\">Datei " . space_html($transquelle) . " konnte nicht heruntergeladen werden</p>";
              }
            }
            if (file_exists($tempdir)) {
              tree_delete_sys($tempdir);
            }
          }
        }
        server_logout();
      }
    } else {
      echo "<p class=\"b mono rot\">Keine Quelle angegeben</p>";
    }
  } else {
    echo "<form action=\"$dateiname\" method=\"post\">";
    post_dump();
    echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Daten von FTP-Server laden - vorhandene Dateien werden &uuml;berschrieben, vorhandene Verzeichnisse werden nicht &uuml;berschrieben:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>
  <table class=\"neutral\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">";
    login_form();
    echo "<tr>
      <td>Quelle:<br>
<input type=\"text\" name=\"transquelle\" size=\"25\" value=\"/\"></td>
    </tr>
    <tr>
      <td>
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"FTP-Download\"></td>
    </tr>
  </table></td>
    </tr>
  </table>
</form>";
  }
} elseif (isset($_POST["ftp_upload"])) {
  if (isset($_POST["ja"])) {
    if (!empty($transziel)) {
      if (!$ftp_login AND !empty($server)) {
        echo "<p class=\"b mono rot\">Anmeldung bei " . space_html($server) . " fehlgeschlagen</p>";
      } elseif (!$ftp_login) {
        echo "<p class=\"b mono rot\">Anmeldung fehlgeschlagen</p>";
      } else {
        if (!ftp_pasv($connect, true)) {
          echo "<p class=\"b mono rot\">Passives FTP konnte nicht eingeschaltet werden - Verbindung zu " . space_html($server) . " ";
          if (ftp_quit($connect)) {
            echo "wurde getrennt</p>";
          } else {
            echo "konnte nicht getrennt werden</p>";
          }
        } else {
          echo "<p class=\"b mono gruen\">Verbindung zu " . space_html($server) . " wurde hergestellt</p>";
          if (!empty($xordner)) {
            $gruen = array();
            $rot = array();
            foreach ($xordner as $v) {
              if (dir_upload($v) !== false) {
                $gruen[] = space_html($v);
              } else {
                $rot[] = space_html($v);
              }
            }
            if (!empty($gruen)) {
              echo "<p class=\"b mono gruen\">";
              if (count($gruen) == 1) {
                echo "Verzeichnis $gruen[0] wurde nach " . space_html($server) . " in Zielverzeichnis " . space_html($transziel) . " hochgeladen";
              } else {
                echo "Folgende Verzeichnisse wurden nach " . space_html($server) . " in Zielverzeichnis " . space_html($transziel) . " hochgeladen:<br>";
                echo implode("<br>", $gruen);
              }
            }
            if (!empty($rot)) {
              echo "<p class=\"b mono rot\">";
              if (count($rot) == 1) {
                echo "Verzeichnis $rot[0] konnte nicht hochgeladen werden";
              } else {
                echo "Folgende Verzeichnisse konnten nicht hochgeladen werden:<br>";
                echo implode("<br>", $rot);
              }
            }
            echo "</p>";
          }
          if (!empty($xdatei)) {
            $gruen = array();
            $rot = array();
            foreach ($xdatei as $v) {
              if (ftp_upload($v, slash($transziel, substr(strrchr($v, "/"), 1)))) {
                $gruen[] = space_html($v);
              } else {
                $rot[] = space_html($v);
              }
            }
            if (!empty($gruen)) {
              echo "<p class=\"b mono gruen\">";
              if (count($gruen) == 1) {
                echo "Datei $gruen[0] wurde nach " . space_html($server) . " in Zielverzeichnis " . space_html($transziel) . " hochgeladen";
              } else {
                echo "Folgende Dateien wurden nach " . space_html($server) . " in Zielverzeichnis " . space_html($transziel) . " hochgeladen:<br>";
                echo implode("<br>", $gruen);
              }
            }
            if (!empty($rot)) {
              echo "<p class=\"b mono rot\">";
              if (count($rot) == 1) {
                echo "Datei $rot[0] konnte nicht hochgeladen werden";
              } else {
                echo "Folgende Dateien konnten nicht hochgeladen werden:<br>";
                echo implode("<br>", $rot);
              }
            }
            echo "</p>";
          }
        }
        server_logout();
      }
    } else {
      echo "<p class=\"b mono rot\">Kein Zielverzeichnis angegeben</p>";
    }
  } else {
    if (!empty($xordner) OR !empty($xdatei)) {
      echo "<form action=\"$dateiname\" method=\"post\">";
      post_dump();
      echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Folgende Daten auf FTP-Server laden - vorhandene Dateien werden &uuml;berschrieben, vorhandene Verzeichnisse werden nicht &uuml;berschrieben:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono gelb\">";
      if (!empty($xordner)) {
        foreach ($xordner as $v) {
          echo space_html($v) . "<br>";
          dir_dump_sys($v);
        }
      }
      if (!empty($xdatei)) {
        echo html_implode($xdatei);
      }
      echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>
  <table class=\"neutral\" border=\"0\" cellpadding=\"0\" cellspacing=\"10\">";
      login_form();
      echo "<tr>
      <td>Zielverzeichnis:<br>
<input type=\"text\" name=\"transziel\" size=\"25\" value=\"/\"></td>
    </tr>
    <tr>
      <td>
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Uploaden\"></td>
    </tr>
  </table></td>
    </tr>
  </table>
</form>";
    } else {
      echo "<p class=\"b mono rot\">Keine Daten angegeben</p>";
    }
  }
} elseif (isset($_POST["highlight"])) {
  if (!empty($xdatei)) {
    if (count($xdatei) > 1) {
      if (isset($_POST["ja"])) {
        if (!empty($xdata)) {
          if (@in_array(substr(strrchr(strtolower($xdata), "."), 1), $highlight_end)) {
            if (is_readable($xdata) AND filesize($xdata) > 0) {
              highlight_code($xdata);
            } else {
              echo "<p class=\"b mono rot\">Quelltext von Datei " . space_html($xdata) . " kann nicht angezeigt werden</p>";
            }
          } else {
            echo "<p class=\"b mono rot\">Dateiformat nicht erlaubt</p>
<p class=\"neutral\">Erlaubte Dateiformate: " . implode(", ", $highlight_end) . "</p>";
          }
        } else {
          echo "<p class=\"b mono rot\">Keine Datei angegeben</p>";
        }
      } else {
        echo "<form action=\"$dateiname\" method=\"post\">";
        post_dump();
        echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Welche Datei soll gehighlightet werden?</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>";
        foreach ($xdatei as $v) {
          echo "<tr>
      <td class=\"nobr neutral pl\">
<input type=\"radio\" class=\"mr10\" name=\"xdata\" value=\"" . htmlentities($v) . "\">" . space_html($v) . "</td>
    </tr>";
        }
        echo "<tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Highlighten\"></td>
    </tr>
  </table>
</form>";
      }
    } else {
      if (@in_array(substr(strrchr(strtolower($xdatei[0]), "."), 1), $highlight_end)) {
        if (is_readable($xdatei[0]) AND filesize($xdatei[0]) > 0) {
          highlight_code($xdatei[0]);
        } else {
          echo "<p class=\"b mono rot\">Quelltext von Datei " . space_html($xdatei[0]) . " kann nicht angezeigt werden</p>";
        }
      } else {
        echo "<p class=\"b mono rot\">Dateiformat nicht erlaubt</p>
<p class=\"neutral\">Erlaubte Dateiformate: " . implode(", ", $highlight_end) . "</p>";
      }
    }
  } else {
    echo "<p class=\"b mono rot\">Keine Datei angegeben</p>";
  }
} elseif (isset($_POST["umlaut_replace"])) {
  if (!empty($xdatei)) {
    if (isset($_POST["ja"])) {
      $gruen = array();
      $rot = array();
      $rotformat = array();
      foreach ($xdatei as $v) {
        if (@in_array(substr(strrchr(strtolower($v), "."), 1), $ersetzen_end)) {
          if (umlaut_replace($v)) {
            $gruen[] = space_html($v);
          } else {
            $rot[] = space_html($v);
          }
        } else {
          $rotformat[] = space_html($v);
        }
      }
      if (!empty($gruen)) {
        echo "<p class=\"b mono gruen\">M&ouml;glicherweise vorhandene Sonderzeichen des deutschen Alphabets wurden in ";
        if (count($gruen) == 1) {
          echo "Datei $gruen[0] durch die entsprechenden HTML-Zeichen ersetzt";
        } else {
          echo "folgenden Dateien durch die entsprechenden HTML-Zeichen ersetzt:<br>";
          echo implode("<br>", $gruen);
        }
      }
      if (!empty($rot)) {
        echo "<p class=\"b mono rot\">";
        if (count($rot) == 1) {
          echo "In Datei $rot[0] wurden keine Sonderzeichen ersetzt";
        } else {
          echo "In folgenden Dateien wurden keine Sonderzeichen ersetzt:<br>";
          echo implode("<br>", $rot);
        }
      }
      if (!empty($rotformat)) {
        echo "<p class=\"b mono rot\">";
        if (count($rotformat) == 1) {
          echo "Dateiformat von Datei $rotformat[0] nicht erlaubt";
        } else {
          echo "Dateiformat folgender Dateien nicht erlaubt:<br>";
          echo implode("<br>", $rotformat);
        }
        echo "</p>
<p class=\"neutral\">Erlaubte Dateiformate: " . implode(", ", $ersetzen_end);
      }
      echo "</p>";
    } else {
      echo "<form action=\"$dateiname\" method=\"post\">";
      post_dump();
      echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Sollen Umlaute und Eszett in ";
      if (count($xdatei) == 1) {
        echo "Datei " . space_html($xdatei[0]) . " durch HTML-Zeichen ersetzt werden?";
      } else {
        echo "folgenden Dateien durch HTML-Zeichen ersetzt werden?<br><br>";
        echo html_implode($xdatei);
      }
      echo "</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"center\">
<input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Ersetzen\"></td>
    </tr>
  </table>
</form>";
    }
  } else {
    echo "<p class=\"b mono rot\">Keine Datei angegeben</p>";
  }
} elseif (isset($_POST["count"])) {
  count_data($verzeichnis);
} elseif (isset($_POST["tree"])) {
  echo "<p class=\"nobr neutral\">";
  tree_dump_sys($verzeichnis);
  echo "</p>";
} elseif (isset($_POST["string_search"])) {
  if (isset($_POST["ja"])) {
    if (!empty($zeichenkette)) {
      $search = string_search_recursive($verzeichnis);
      if (!$search) {
        echo "<p class=\"b mono rot\">";
        if (strlen($zeichenkette) > 1) {
          echo "Zeichenkette";
        } else {
          echo "Zeichen";
        }
        echo " &quot;" . space_html($zeichenkette) . "&quot; wurde nicht gefunden</p>";
        if ($case != 1 AND strpos_umlaut($zeichenkette)) {
          echo "<p class=\"neutral\">Umlaute und andere Buchstaben mit diakritischen Zeichen k&ouml;nnen bei abweichender Gro&szlig;- und Kleinschreibung nicht gefunden werden</p>";
        }
      } else {
        echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($verzeichnis) . "\">
<input type=\"hidden\" name=\"zeichenkette\" value=\"" . htmlentities($zeichenkette) . "\">
<input type=\"hidden\" name=\"case\" value=\"$case\">
  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">";
        if (strlen($zeichenkette) > 1) {
          echo "Zeichenkette";
        } else {
          echo "Zeichen";
        }
        echo " &quot;" . space_html($zeichenkette) . "&quot; wurde ";
        if ($case == 1) {
          echo "unter";
        } else {
          echo "ohne";
        }
        echo " Beachtung der Gro&szlig;- und Kleinschreibung in folgenden Dateien gefunden und kann in auszuw&auml;hlenden Dateien ersetzt werden:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"nobr neutral pl\">$search</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono gelb\">";
        if (strlen($zeichenkette) > 1) {
          echo "Zeichenkette";
        } else {
          echo "Zeichen";
        }
        echo " &quot;" . space_html($zeichenkette) . "&quot; ";
        if ($case == 1) {
          echo "unter";
        } else {
          echo "ohne";
        }
        echo " Beachtung der Gro&szlig;- und Kleinschreibung in ausgew&auml;hlten Dateien ersetzen durch (leere Eingabe l&ouml;scht Zeichen):</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"nobr\">
<input type=\"text\" class=\"mr10\" name=\"zeichenkette2\" size=\"40\" value=\"" . htmlentities($zeichenkette) . "\"><input type=\"submit\" name=\"string_replace\" id=\"ja\" value=\"Ersetzen\"></td>
    </tr>
  </table>
</form>";
      }
    } else {
      echo "<p class=\"b mono rot\">Keine Zeichenkette angegeben</p>";
    }
  } else {
    $inhalt = data_list($verzeichnis);
    echo "<form action=\"$dateiname\" method=\"post\">";
    post_dump();
    echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
    <tr>
      <td class=\"b mono gelb\">Dateien mit den Endungen " . implode(", ", $suchen_end);
  if (show_button_sys($suchen_end, $inhalt[1])) {
    echo " im aktuellen Verzeichnis";
  }
  echo " nach Zeichen durchsuchen:</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"nobr\">
<input type=\"text\" class=\"mr10\" name=\"zeichenkette\" size=\"40\"><input type=\"submit\" name=\"ja\" id=\"ja\" value=\"Suchen\"></td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td class=\"b mono gelb\"><input type=\"checkbox\" name=\"case\" value=\"1\" checked> Gro&szlig;- und Kleinschreibung";
    if (!empty($inhalt[0]) AND show_button_sys($suchen_end, $inhalt[1])) {
      echo "<br>
<input type=\"checkbox\" name=\"subdir\" value=\"1\" checked> Unterverzeichnisse";
    } elseif (!empty($inhalt[0])) {
      echo "<input type=\"hidden\" name=\"subdir\" value=\"1\">";
    }
    echo "</td>
    </tr>
  </table>
</form>";
  }
} elseif (isset($_POST["string_replace"])) {
  if (empty($xdata)) {
    echo "<p class=\"b mono rot\">Keine Datei angegeben</p>";
  } else {
    $gruen = array();
    $rot = array();
    foreach ($xdata as $v) {
      if (string_replace($v)) {
        $gruen[] = space_html($v);
      } else {
        $rot[] = space_html($v);
      }
    }
    if (!empty($gruen)) {
      echo "<p class=\"b mono gruen\">";
      if (strlen($zeichenkette) > 1) {
        echo "Zeichenkette";
      } else {
        echo "Zeichen";
      }
      echo " &quot;" . space_html($zeichenkette) . "&quot; wurde ";
      if ($case == 1) {
        echo "unter";
      } else {
        echo "ohne";
      }
      echo " Beachtung der Gro&szlig;- und Kleinschreibung in ";
      if (count($gruen) == 1) {
        echo "Datei $gruen[0]";
      } else {
        echo "folgenden Dateien";
      }
      if (!empty($zeichenkette2)) {
        echo " durch ";
        if (strlen($zeichenkette2) > 1) {
          echo "Zeichenkette";
        } else {
          echo "Zeichen";
        }
        echo " &quot;" . space_html($zeichenkette2) . "&quot; ersetzt";
        if (count($gruen) > 1) {
          echo ":<br>";
          echo implode("<br>", $gruen);
        }
      } else {
        echo " gel&ouml;scht";
        if (count($gruen) > 1) {
          echo ":<br>";
          echo implode("<br>", $gruen);
        }
      }
    }
    if (!empty($rot)) {
      echo "<p class=\"b mono rot\">";
      if (count($rot) == 1) {
        echo "In Datei $rot[0] wurden keine Zeichen ersetzt";
      } else {
        echo "In folgenden Dateien wurden keine Zeichen ersetzt:<br>";
        echo implode("<br>", $rot);
      }
    }
    echo "</p>";
  }
}
if (!isset($_POST["download_gz"]) OR empty($gz)) {
  if (data_list($verzeichnis) != false OR data_list($verzeichnis) == false) {
    $cwd = @is_readable($verzeichnis) ? $verzeichnis : $scriptdir;
    $data_list = data_list($cwd);
    if (empty($verzeichnis)) {
      echo "<p class=\"b mono rot\">Kein Verzeichnis angegeben</p>";
    } elseif (!@is_readable($verzeichnis)) {
      echo "<p class=\"b mono rot\">Konnte nicht ins Verzeichnis " . space_html($verzeichnis) . " wechseln</p>";
    }
    echo "<p class=\"nobr size14 grau4\">" . space_html($cwd) . "</p>";
    $cdup = substr($cwd, 0, -strlen(substr(strrchr($cwd, "/"), 1)));
    if (strlen($cwd) > 1 AND @is_readable($cdup)) {
      echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($cdup) . "\">
<p><input type=\"submit\" class=\"button\" value=\"Ebene h&ouml;her\"></p>
</form>";
    }
    echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($cwd) . "\">
  <table class=\"list w100\" border=\"0\" cellpadding=\"2\" cellspacing=\"3\">";
    if (!empty($data_list[0])) {
      foreach ($data_list[0] as $v) {
        $pfad = slash($cwd, $v);
        echo "<tr class=\"grau\">
      <td class=\"td1\">
<input type=\"checkbox\" name=\"xordner[]\" value=\"" . htmlentities($pfad) . "\"></td>
      <td class=\"td2";
        if (!is_writeable($pfad)) {
          echo " rot";
        }
        echo "\">[ ";
        if (is_readable($pfad)) {
          echo "<a href=\"" . $dateiname . "?verzeichnis=" . urlencode($pfad) . "\">";
        }
        echo space_html($v);
        if (is_readable($pfad)) {
          echo "</a>";
        }
        echo " ]</td>
      <td class=\"td33";
        if (!is_writeable($pfad)) {
          echo " rot";
        }
        echo "\"";
        if (!empty($data_list[1])) {
          echo " colspan=\"2\">";
        } else {
          echo ">";
        }
        echo substr(decoct(fileperms($pfad)), -4) . "</td>
      <td class=\"td3";
        if (!is_writeable($pfad)) {
          echo " rot";
        }
        echo "\">" . date("r", filemtime($pfad)) . "</td>
    </tr>";
      }
    }
    if (!empty($data_list[1])) {
      foreach ($data_list[1] as $v) {
        $pfad = slash($cwd, $v);
        echo "<tr class=\"grau2\">
      <td class=\"td1\">
<input type=\"checkbox\" name=\"xdatei[]\" value=\"" . htmlentities($pfad) . "\"></td>
      <td class=\"td2";
        if (!is_writeable($pfad)) {
          echo " rot";
        }
        echo "\">" . space_html($v) . "</td>
      <td class=\"td3";
        if (!is_writeable($pfad)) {
          echo " rot";
        }
        echo "\">" . substr(decoct(fileperms($pfad)), -4) . "</td>
      <td class=\"td3";
        if (!is_writeable($pfad)) {
          echo " rot";
        }
        echo " right\">" . filesize($pfad) . " Byte</td>
      <td class=\"td3";
        if (!is_writeable($pfad)) {
          echo " rot";
        }
        echo "\">" . date("r", filemtime($pfad)) . "</td>
    </tr>";
      }
    }
    if (!$data_list) {
      echo "<tr>
      <td class=\"neutral center\">keine Inhalte erkannt</td>
    </tr>";
    }
    echo "</table>";
    if ($data_list != false) {
      echo "<p>";
      if (is_writeable($cwd)) {
        echo "<input type=\"submit\" class=\"button mr10\" name=\"rmdir_delete\" value=\"l&ouml;schen\"><input type=\"submit\" class=\"button mr10\" name=\"rename\" value=\"umbenennen\"><input type=\"submit\" class=\"button mr10\" name=\"move\" value=\"verschieben\">";
        if (show_button_edit($data_list[1])) {
          echo "<input type=\"submit\" class=\"button mr10\" name=\"edit\" value=\"bearbeiten\">";
          if (show_button_sys($ersetzen_end, $data_list[1])) {
            echo "<input type=\"submit\" class=\"button mr10\" name=\"umlaut_replace\" value=\"ersetzen\">";
          }
        }
      }
      if (show_button_sys($highlight_end, $data_list[1]) AND not_disabled("highlight_file")) {
          echo "<input type=\"submit\" class=\"button mr10\" name=\"highlight\" value=\"highlighten\">";
      }
      if (function_exists("ftp_connect") AND function_exists("curl_init")) {
        echo "<input type=\"submit\" class=\"button mr10\" name=\"ftp_upload\" value=\"uploaden\">";
      }
      if (!empty($data_list[1]) AND function_exists("gzencode") AND is_writeable($scriptdir)) {
        echo "<input type=\"submit\" class=\"button mr10\" name=\"download\" value=\"downloaden\">";
      }
      if (not_disabled("chmod")) {
        echo "<input type=\"submit\" class=\"button mr10\" name=\"chmod\" value=\"chmodden\">";
      }
      echo "<input type=\"submit\" class=\"button\" name=\"copy\" value=\"kopieren\"></p>";
    }
    echo "</form>
<form action=\"$dateiname\" method=\"post\">
<p class=\"nobr\"><input type=\"text\" class=\"mr10\" name=\"verzeichnis\" size=\"40\" value=\"" . htmlentities($cwd) . "\"><input type=\"submit\" class=\"button\" value=\"browsen\"></p>
</form>";
    if (is_writeable($cwd)) {
      echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($cwd) . "\">
<p class=\"nobr\"><input type=\"text\" class=\"mr10\" name=\"ordner\" size=\"25\"><input type=\"submit\" class=\"button\" name=\"mkdir\" value=\"Ordner erstellen\"></p>
</form>
<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($cwd) . "\">
<p class=\"nobr\"><input type=\"text\" class=\"mr10\" name=\"datei\" size=\"25\"><input type=\"submit\" class=\"button\" name=\"create\" value=\"Datei erstellen\"></p>
</form>
<form enctype=\"multipart/form-data\" action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($cwd) . "\">
  <table border=\"0\" cellpadding=\"2\" cellspacing=\"3\">
    <tr>
      <td>
<input type=\"file\" name=\"file\"></td>
      <td>
<input type=\"submit\" class=\"button\" name=\"upload\" value=\"Datei hochladen\"></td>
    </tr>
  </table>
</form>";
    }
    if ($data_list != false) {
      echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($cwd) . "\"><p>";
      if (!empty($data_list[0]) OR show_button_sys($suchen_end, $data_list[1])) {
        echo "<input type=\"submit\" class=\"button mr10\" name=\"string_search\" value=\"Zeichensuche\">";
      }
      echo "<input type=\"submit\" class=\"button mr10\" name=\"count\" value=\"Z&auml;hlen\"><input type=\"submit\" class=\"button\" name=\"tree\" value=\"Verzeichnisbaum\"></p>
</form>";
    }
    if (is_writeable($cwd) AND ((function_exists("ftp_connect") AND function_exists("curl_init")) OR (show_button_auth($data_list[1]) !== false))) {
      echo "<form action=\"$dateiname\" method=\"post\">
<input type=\"hidden\" name=\"verzeichnis\" value=\"" . htmlentities($cwd) . "\"><p>";
      if (function_exists("ftp_connect") AND function_exists("curl_init")) {
        echo "<input type=\"submit\" class=\"button";
        if (show_button_auth($data_list[1]) !== false) {
          echo " mr10";
        }
        echo "\" name=\"ftp_download\" value=\"FTP-Download\">";
      }
      if (show_button_auth($data_list[1]) !== false) {
        echo "<input type=\"submit\" class=\"button\" name=\"auth\" value=\"Verzeichnisschutz\">";
      }
      echo "</p></form>";
    }
  }
  echo "</body>
</html>";
}
?>